/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.sqs_xml.reader.model.IRNSContainer;
import net.sf.sqs_xml.reader.model.IRNode;
import net.sf.sqs_xml.reader.model.ImageFiles;
import net.sf.sqs_xml.reader.model.RNSContext;
import net.sf.sqs_xml.reader.model.RStack;
import net.sf.sqs_xml.reader.model.UJAXP;
import net.sf.sqs_xml.reader.model.URelaxer;
import net.sf.sqs_xml.reader.model.URelaxer2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReadingState
implements Serializable,
Cloneable,
IRNSContainer,
IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
    private String imagedir_;
    private String pdffile_;
    private Timestamp start_;
    private Timestamp end_;
    private ImageFiles imageFiles_;
    private String answers_;
    private Element xmlElement;
    private IRNode parentRNode_;

    public ReadingState() {
        this.imagedir_ = "";
        this.pdffile_ = "";
        this.start_ = URelaxer.makeAutoSQLTimestamp();
        this.end_ = URelaxer.makeAutoSQLTimestamp();
    }

    public ReadingState(ReadingState source) {
        this.setup(source);
    }

    public ReadingState(RStack stack) {
        this.setup(stack);
    }

    public ReadingState(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public ReadingState(Element element) {
        this.setup(element);
    }

    public ReadingState(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public ReadingState(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public ReadingState(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public ReadingState(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public ReadingState(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public ReadingState(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(ReadingState source) {
        this.imagedir_ = source.imagedir_;
        this.pdffile_ = source.pdffile_;
        this.start_ = source.start_;
        this.end_ = source.end_;
        if (source.imageFiles_ != null) {
            this.setImageFiles((ImageFiles)source.getImageFiles().clone());
        }
        this.answers_ = source.answers_;
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        this.xmlElement = element;
        RStack stack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.imagedir_ = URelaxer.getAttributePropertyAsString(element, "imagedir");
        this.pdffile_ = URelaxer.getAttributePropertyAsString(element, "pdffile");
        this.start_ = URelaxer.getAttributePropertyAsSQLTimestamp(element, "start");
        this.end_ = URelaxer.getAttributePropertyAsSQLTimestamp(element, "end");
        if (ImageFiles.isMatch(stack)) {
            this.setImageFiles(new ImageFiles(stack));
        }
        this.answers_ = URelaxer2.getElementPropertyAsStringByStack(stack, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "answers");
    }

    public Object clone() {
        return new ReadingState(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS("http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "readingState");
        this.rNSContext_.setupNamespace(element);
        if (this.imagedir_ != null) {
            URelaxer.setAttributePropertyByString(element, "imagedir", this.imagedir_);
        }
        if (this.pdffile_ != null) {
            URelaxer.setAttributePropertyByString(element, "pdffile", this.pdffile_);
        }
        if (this.start_ != null) {
            URelaxer.setAttributePropertyBySQLTimestamp(element, "start", this.start_);
        }
        if (this.end_ != null) {
            URelaxer.setAttributePropertyBySQLTimestamp(element, "end", this.end_);
        }
        if (this.imageFiles_ != null) {
            this.imageFiles_.makeElement(element);
        }
        if (this.answers_ != null) {
            URelaxer2.setElementPropertyByString(element, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "answers", this.answers_, this.rNSContext_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 2));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 2));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 2));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public String getImagedir() {
        return this.imagedir_;
    }

    public void setImagedir(String imagedir) {
        this.imagedir_ = imagedir;
    }

    public String getPdffile() {
        return this.pdffile_;
    }

    public void setPdffile(String pdffile) {
        this.pdffile_ = pdffile;
    }

    public Timestamp getStart() {
        return this.start_;
    }

    public void setStart(Timestamp start) {
        this.start_ = start;
    }

    public Timestamp getEnd() {
        return this.end_;
    }

    public void setEnd(Timestamp end) {
        this.end_ = end;
    }

    public ImageFiles getImageFiles() {
        return this.imageFiles_;
    }

    public void setImageFiles(ImageFiles imageFiles) {
        this.imageFiles_ = imageFiles;
        if (imageFiles != null) {
            imageFiles.rSetParentRNode(this);
        }
    }

    public String getAnswers() {
        return this.answers_;
    }

    public void setAnswers(String answers) {
        this.answers_ = answers;
    }

    public Element rGetElement() {
        return this.xmlElement;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.append("<");
        URelaxer.makeQName(prefix, "readingState", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.imagedir_ != null) {
            buffer.append(" ");
            buffer.append("imagedir");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getImagedir())));
            buffer.append("\"");
        }
        if (this.pdffile_ != null) {
            buffer.append(" ");
            buffer.append("pdffile");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPdffile())));
            buffer.append("\"");
        }
        if (this.start_ != null) {
            buffer.append(" ");
            buffer.append("start");
            buffer.append("=\"");
            buffer.append(URelaxer.getString(this.getStart()));
            buffer.append("\"");
        }
        if (this.end_ != null) {
            buffer.append(" ");
            buffer.append("end");
            buffer.append("=\"");
            buffer.append(URelaxer.getString(this.getEnd()));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.imageFiles_ != null) {
            this.imageFiles_.makeTextElement(buffer);
        }
        if (this.answers_ != null) {
            buffer.append("<");
            URelaxer.makeQName(prefix, "answers", buffer);
            buffer.append(">");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getAnswers())));
            buffer.append("</");
            URelaxer.makeQName(prefix, "answers", buffer);
            buffer.append(">");
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "readingState", buffer);
        buffer.append(">");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.write("<");
        URelaxer.makeQName(prefix, "readingState", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.imagedir_ != null) {
            buffer.write(" ");
            buffer.write("imagedir");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getImagedir())));
            buffer.write("\"");
        }
        if (this.pdffile_ != null) {
            buffer.write(" ");
            buffer.write("pdffile");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPdffile())));
            buffer.write("\"");
        }
        if (this.start_ != null) {
            buffer.write(" ");
            buffer.write("start");
            buffer.write("=\"");
            buffer.write(URelaxer.getString(this.getStart()));
            buffer.write("\"");
        }
        if (this.end_ != null) {
            buffer.write(" ");
            buffer.write("end");
            buffer.write("=\"");
            buffer.write(URelaxer.getString(this.getEnd()));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.imageFiles_ != null) {
            this.imageFiles_.makeTextElement(buffer);
        }
        if (this.answers_ != null) {
            buffer.write("<");
            URelaxer.makeQName(prefix, "answers", buffer);
            buffer.write(">");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getAnswers())));
            buffer.write("</");
            URelaxer.makeQName(prefix, "answers", buffer);
            buffer.write(">");
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "readingState", buffer);
        buffer.write(">");
    }

    public void makeTextElement(PrintWriter buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.print("<");
        URelaxer.makeQName(prefix, "readingState", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.imagedir_ != null) {
            buffer.print(" ");
            buffer.print("imagedir");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getImagedir())));
            buffer.print("\"");
        }
        if (this.pdffile_ != null) {
            buffer.print(" ");
            buffer.print("pdffile");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPdffile())));
            buffer.print("\"");
        }
        if (this.start_ != null) {
            buffer.print(" ");
            buffer.print("start");
            buffer.print("=\"");
            buffer.print(URelaxer.getString(this.getStart()));
            buffer.print("\"");
        }
        if (this.end_ != null) {
            buffer.print(" ");
            buffer.print("end");
            buffer.print("=\"");
            buffer.print(URelaxer.getString(this.getEnd()));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.imageFiles_ != null) {
            this.imageFiles_.makeTextElement(buffer);
        }
        if (this.answers_ != null) {
            buffer.print("<");
            URelaxer.makeQName(prefix, "answers", buffer);
            buffer.print(">");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getAnswers())));
            buffer.print("</");
            URelaxer.makeQName(prefix, "answers", buffer);
            buffer.print(">");
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "readingState", buffer);
        buffer.print(">");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getImagedirAsString() {
        return URelaxer.getString(this.getImagedir());
    }

    public String getPdffileAsString() {
        return URelaxer.getString(this.getPdffile());
    }

    public String getStartAsString() {
        return URelaxer.getString(this.getStart());
    }

    public String getEndAsString() {
        return URelaxer.getString(this.getEnd());
    }

    public String getAnswersAsString() {
        return URelaxer.getString(this.getAnswers());
    }

    public void setImagedirByString(String string) {
        this.setImagedir(string);
    }

    public void setPdffileByString(String string) {
        this.setPdffile(string);
    }

    public void setStartByString(String string) {
        this.setStart(URelaxer.getSQLTimestamp(string));
    }

    public void setEndByString(String string) {
        this.setEnd(URelaxer.getSQLTimestamp(string));
    }

    public void setAnswersByString(String string) {
        this.setAnswers(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<ImageFiles> classNodes = new ArrayList<ImageFiles>();
        if (this.imageFiles_ != null) {
            classNodes.add(this.imageFiles_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "readingState")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "imagedir")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "pdffile")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "start")) {
            return false;
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "end")) {
            return false;
        }
        $match$ = true;
        ImageFiles.isMatchHungry(target);
        Element child = target.peekElement();
        if (child != null && URelaxer2.isTargetElement(child, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "answers")) {
            target.popElement();
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return ReadingState.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (ReadingState.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

