/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.swing;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.sqs_xml.editor.sqs.swing.SQSFileChooser;
import net.sf.sqs_xml.httpd.MarkReaderHttpd;
import net.sf.sqs_xml.reader.logic.MarkReaderTranslator;
import net.sf.sqs_xml.reader.swing.ProgressLoggerConsoleFrame;
import net.sf.sqs_xml.swing.IconFactory;
import net.sf.sqs_xml.swing.LoggerConsoleFrame;
import net.sf.sqs_xml.swing.SwingUtil;
import net.sf.sqs_xml.translator.logic.Translator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;
import net.sf.sqs_xml.translator.swing.SQSFileTranslator;
import org.xml.sax.SAXException;

public class MarkReader
extends SQSFileTranslator {
    public static final String BASEURI = MarkReaderHttpd.getSingleton().getBase();
    static final String TITLE = "SQS MarkReader(2004/11/02)";

    static {
        IconFactory.setBaseURI(MarkReaderHttpd.getSingleton().getBase());
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("swing.plaf.metal.controlFont", "Monospaced-12");
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        SwingUtil.Factory factory = new SwingUtil.Factory(){

            public Object create() throws Exception {
                return MarkReader.createReaderLogic();
            }
        };
        MarkReaderTranslator translator = (MarkReaderTranslator)SwingUtil.newInstanceWithWaitPromptFrame(factory, TITLE, "Initializing...");
        File dir = null;
        if (args.length > 0 && !(dir = new File(args[0])).isDirectory()) {
            dir = null;
        }
        MarkReader self = new MarkReader(dir, translator);
        if (dir != null) {
            self.setSlectedFile(dir);
            self.fileSaveButton.setEnabled(true);
            self.fileSaveButton.setFocusable(true);
        }
    }

    static MarkReaderTranslator createReaderLogic() throws TranslatorException, ParserConfigurationException, SAXException, IOException {
        return new MarkReaderTranslator(){

            public void initializeEnvironment() {
                LoggerConsoleFrame logger = this.getLogger();
                logger.setDebugEnabled(false);
                JButton cancelButton = logger.getCancelButton();
                cancelButton.addActionListener(new ActionListener(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent ev) {
                        this.this$1.setSuspending();
                    }
                });
                logger.setDefaultCloseOperation(2);
                logger.addWindowListener(new WindowAdapter(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void windowClosed(WindowEvent ev) {
                        this.this$1.setSuspending();
                    }
                });
            }
        };
    }

    public MarkReader(File dir, Translator translator) throws Exception {
        super(IconFactory.create("reader.gif"), TITLE, translator, SQSFileChooser.createOpenSQSFolderChooser(dir), "\u30d5\u30a9\u30eb\u30c0(\u30b9\u30ad\u30e3\u30f3\u753b\u50cf\u3068\u5370\u5237\u539f\u7a3fPDF\u30d5\u30a1\u30a4\u30eb\u3092\u542b\u3080\u3082\u306e):", null, "\u96c6\u8a08\u7d50\u679c\u30c7\u30fc\u30bf");
        this.setSize(400, 215);
        this.inputFileChooserPanel.getFileDropAcceptableTextField().setToolTipText("\u300c\u30b9\u30ad\u30e3\u30f3\u3057\u305f\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u300d\u3068\u300c\u8abf\u67fb\u7968\u5370\u5237\u539f\u7a3f\u306ePDF\u30d5\u30a1\u30a4\u30eb\u300d\u3092\u542b\u3080\u30d5\u30a9\u30eb\u30c0\u3092drag&drop\u3057\u3066\u304f\u3060\u3055\u3044");
        this.fileSaveButton.setToolTipText("\u8aad\u307f\u53d6\u308a\u51e6\u7406\u3092\u5b9f\u884c\u3057\u307e\u3059");
        this.setVisible(true);
    }

    public JFileChooser createInputFileChooser() {
        return SQSFileChooser.createOpenSQSSourceChooser(null);
    }

    public JFileChooser createOutputFileChooser(File file) {
        return SQSFileChooser.createSaveReaderResultFolderChooser(file);
    }

    public LoggerConsoleFrame createLoggerConsoleFrame() {
        final ProgressLoggerConsoleFrame logger = new ProgressLoggerConsoleFrame("SQS MarkReader(2004/11/02) \u9032\u6357\u72b6\u6cc1", "\u30ad\u30e3\u30f3\u30bb\u30eb", "\u5b8c\u4e86");
        logger.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                logger.setVisible(false);
                logger.setFinished(true);
                MarkReader.this.setFinished(true);
            }
        });
        logger.setFinished(false);
        return logger;
    }

    public void save(File sourceFile) {
        if (!sourceFile.isDirectory()) {
            JOptionPane.showMessageDialog(this, "\u30d5\u30a9\u30eb\u30c0\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044");
            return;
        }
        super.save(sourceFile);
    }

    public void translate(final File sourceFile, File dummy) {
        final File targetFile = this.selectTargetFile(sourceFile);
        if (targetFile == null) {
            this.setFinished(true);
            return;
        }
        final TranslatorResource resource = this.createResource();
        new Thread(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        ((MarkReaderTranslator)MarkReader.this.translator).translate(sourceFile, resource, targetFile);
                        ((LoggerConsoleFrame)resource.getLogger()).setFinished(true);
                    }
                    catch (TranslatorException e) {
                        e.printStackTrace();
                        this.showError((LoggerConsoleFrame)resource.getLogger(), e);
                        ((LoggerConsoleFrame)resource.getLogger()).setFinished(false);
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    MarkReader.this.inputFileChooserPanel.setEnabled(true);
                    MarkReader.this.fileSaveButton.setEnabled(true);
                    MarkReader.this.setCursor(Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                    MarkReader.this.inputFileChooserPanel.setEnabled(true);
                }
                MarkReader.this.fileSaveButton.setEnabled(true);
                MarkReader.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            public void showError(JFrame logger, Exception e) {
                JOptionPane.showMessageDialog(logger, e.getLocalizedMessage(), "ERROR-TRANSLATE", 0);
            }
        }.start();
    }

    private File selectTargetFile(File sourceFile) {
        File parentdir = sourceFile.getParentFile();
        File tgtdir = new File(parentdir.getAbsoluteFile() + File.separator + sourceFile.getName() + "-RESULT");
        while (true) {
            String tgtName;
            int option;
            if (tgtdir.exists() && tgtdir.isDirectory()) {
                option = JOptionPane.showConfirmDialog(this, new String[]{"\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\uff0e", "\u4fdd\u5b58\u5148:" + tgtdir, "\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u306e\u5185\u5bb9\u3092\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b?"}, "\u78ba\u8a8d", 1);
                if (option == 0) {
                    tgtdir.delete();
                    tgtdir.mkdir();
                    break;
                }
                if (2 == option) {
                    return null;
                }
            } else {
                option = JOptionPane.showConfirmDialog(this, new String[]{"\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\uff0e", "\u4fdd\u5b58\u5148:" + tgtdir, "\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210\u3057\u307e\u3059\u304b?"}, "\u78ba\u8a8d", 1);
                if (option == 0) {
                    tgtdir.mkdir();
                    break;
                }
                if (2 == option) {
                    return null;
                }
            }
            if ((tgtName = JOptionPane.showInputDialog(this, new String[]{"\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\uff0e", "\u4fdd\u5b58\u5148:" + parentdir.getAbsoluteFile() + File.separator}, tgtdir.getName())) == null) continue;
            tgtdir = new File(parentdir.getAbsoluteFile() + File.separator + tgtName);
        }
        return tgtdir;
    }
}

