/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.translator.logic;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.sqs_xml.httpd.MarkReaderHttpd;
import net.sf.sqs_xml.translator.logic.AbstractTranslator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;

public class PDFtoSQMTranslator
extends AbstractTranslator {
    public static final String BOOKMARK2SQM = AbstractTranslator.prop.getString("bookmark2sqm_xsl_file");
    int numberOfPages = -1;

    public static void main(String[] args) throws Exception {
        AbstractTranslator.main(args, "jp.sourceforge.sqs_xml.translator.logic.PDFtoSQMTranslator <in.pdf> <out.sqm>", BOOKMARK2SQM.split(" "), new PDFtoSQMTranslator(), MarkReaderHttpd.getSingleton().getBase());
    }

    public void translate(InputStream inputStream, TranslatorResource resource, OutputStream outputStream, String baseURI) throws TranslatorException {
        try {
            PdfReader reader = this.createPdfReader(inputStream);
            ByteArrayOutputStream bookmarkOutputStream = new ByteArrayOutputStream(4096);
            SimpleBookmark.exportToXML((List)SimpleBookmark.getBookmark((PdfReader)reader), (OutputStream)bookmarkOutputStream, (String)"UTF-8", (boolean)false);
            this.numberOfPages = reader.getNumberOfPages();
            ByteArrayInputStream bookmarkInputStream = new ByteArrayInputStream(bookmarkOutputStream.toByteArray());
            super.translate(bookmarkInputStream, resource, outputStream, baseURI);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void execute(InputStream inputStream, TranslatorResource resource, OutputStream outputStream, TransformerHandler starterHandler, TransformerHandler terminatorHandler) throws TranslatorException {
        try {
            Serializer serializer = SerializerFactory.getSerializer((Properties)OutputPropertiesFactory.getDefaultMethodProperties((String)"xml"));
            serializer.setOutputStream(outputStream);
            terminatorHandler.setResult(new SAXResult(serializer.asContentHandler()));
        }
        catch (IOException ex) {
            throw new TranslatorException(ex);
        }
    }

    public String[] getParameters(String filename) {
        return new String[]{"pages", new Integer(this.numberOfPages).toString()};
    }

    private PdfReader createPdfReader(InputStream pdfInputStream) throws IOException {
        ByteArrayOutputStream pdfOutputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = pdfInputStream.read(buf)) > 0) {
            pdfOutputStream.write(buf, 0, len);
        }
        PdfReader reader = new PdfReader(pdfOutputStream.toByteArray());
        return reader;
    }
}

