/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.translator.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.sqs_xml.translator.servlet.UploadedFile;
import net.sf.sqs_xml.util.StringUtil;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

public class FileUploadReceiver {
    public static UploadedFile receiveFileUpload(HttpServletRequest req, HttpServletResponse res, String fileParamName) throws ServletException, IOException {
        try {
            DiskFileUpload fu = FileUploadReceiver.createDiskFileUpload();
            File tmpdir = FileUploadReceiver.createTmpDirectory();
            fu.setRepositoryPath(tmpdir.getAbsolutePath());
            List fileItems = fu.parseRequest(req);
            Iterator it = fileItems.iterator();
            while (it.hasNext()) {
                FileItem item = (FileItem)it.next();
                if (item.isFormField()) continue;
                String fieldName = item.getFieldName();
                String fileName = item.getName();
                String fileNameBody = StringUtil.chop(new File(fileName).getName(), ".");
                if (!fileParamName.equals(fieldName)) continue;
                if (item.getSize() == 0L) {
                    throw new FileNotFoundException(fileName);
                }
                return new UploadedFile(fileNameBody, item.getInputStream());
            }
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            FileUploadReceiver.responseErrorMessage(res);
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        throw new ServletException();
    }

    private static void responseErrorMessage(HttpServletResponse res) throws IOException {
        res.setContentType("text/plain");
        PrintWriter writer = new PrintWriter(res.getWriter());
        writer.println("File Not Found or File Length is zero.");
        writer.close();
    }

    private static File createTmpDirectory() {
        File tmpdir = new File(String.valueOf(System.getProperty("java.io.tmpdir", "/tmp")) + File.separator + "uploadfile");
        if (!tmpdir.exists()) {
            tmpdir.mkdirs();
        }
        return tmpdir;
    }

    private static DiskFileUpload createDiskFileUpload() {
        DiskFileUpload fu = new DiskFileUpload();
        fu.setSizeThreshold(65546);
        fu.setSizeMax(1000000L);
        return fu;
    }
}

