/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import net.sf.sqs_xml.util.StringUtil;

public class FileUtil {
    public static URL toURL(File tgtFile) throws UnsupportedEncodingException, MalformedURLException, IOException {
        return new URL(FileUtil.toURLString(tgtFile));
    }

    public static String toURLString(File tgtFile) throws UnsupportedEncodingException, IOException {
        return FileUtil.toURLString(tgtFile.getAbsolutePath());
    }

    public static String toURLString(String tgtFilePath) throws UnsupportedEncodingException, IOException {
        String[] path = tgtFilePath.split(File.separator);
        StringBuffer f = new StringBuffer();
        int i = 0;
        while (i < path.length) {
            if (i == 0) {
                if (File.pathSeparatorChar == '\\' && path[0].indexOf(":") < 0) {
                    f.append("/");
                }
                f.append(path[i]);
            } else {
                f.append("/");
                f.append(StringUtil.replaceAll(URLEncoder.encode(path[i], "MS932"), "+", "%20"));
            }
            ++i;
        }
        return "file:///" + f.toString();
    }

    public static void createDirectory(String absolutePath) {
        StringBuffer path = new StringBuffer();
        String[] dirs = absolutePath.split("/");
        int i = 0;
        while (i < dirs.length) {
            if (i > 0) {
                path.append(File.separator);
            }
            path.append(dirs[i]);
            File dir = new File(path.toString());
            if (!dir.isDirectory()) {
                dir.mkdir();
            }
            ++i;
        }
    }

    public static void clearDirectory(String absolutePath) {
        File[] list = new File(absolutePath).listFiles();
        int i = 0;
        while (i < list.length) {
            File file = list[i];
            list[i].delete();
            ++i;
        }
    }

    public static List find(String absolutePath, String suffix) {
        return FileUtil.find(new File(absolutePath), suffix);
    }

    public static List find(File absolutePath, final String suffix) {
        return FileUtil.find(absolutePath, new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(suffix);
            }
        });
    }

    public static List find(File path, FileFilter filter) {
        LinkedList sourceFileList = new LinkedList();
        return FileUtil.addFoundFileToList(sourceFileList, path, filter);
    }

    private static List addFoundFileToList(List sourceFileList, File current, FileFilter filter) {
        Object file;
        Object[] members = null;
        members = current.listFiles(filter);
        if (members == null) {
            return new LinkedList();
        }
        Arrays.sort(members);
        int i = 0;
        while (i < members.length) {
            file = members[i];
            sourceFileList.add(file);
            ++i;
        }
        members = current.listFiles();
        Arrays.sort(members);
        i = 0;
        while (i < members.length) {
            file = members[i];
            if (((File)file).isDirectory()) {
                FileUtil.addFoundFileToList(sourceFileList, (File)file, filter);
            }
            ++i;
        }
        return sourceFileList;
    }

    public static void keywordSubstitution(File file, String from, String to) {
        String encoding = "UTF-8";
        FileUtil.keywordSubstitution(file, from, to, encoding);
    }

    public static boolean keywordSubstitution(File file, String from, String to, String encoding) {
        try {
            File tmpfile = File.createTempFile("tmp", "txt'");
            boolean modified = FileUtil.keywordSubstitution(new FileInputStream(file), new FileOutputStream(tmpfile), from, to, encoding);
            if (modified) {
                file.delete();
                FileUtil.copy(tmpfile, file, encoding);
            } else {
                tmpfile.delete();
            }
            return modified;
        }
        catch (IOException e) {
            e.printStackTrace();
            new RuntimeException(e);
            return false;
        }
    }

    public static boolean keywordSubstitution(InputStream inputStream, OutputStream outputStream, String from, String to, String encoding) {
        boolean modified = false;
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), encoding));
            LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream), encoding));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String result = StringUtil.replaceAll(line, from, to);
                writer.println(result);
                if (result.equals(line)) continue;
                modified |= true;
            }
            reader.close();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            new RuntimeException(e);
        }
        return modified;
    }

    public static boolean copy(File from, File to, String encoding) {
        try {
            LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(from)), encoding));
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(to)), encoding));
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
            reader.close();
            writer.close();
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getSuffix(File filename) {
        return FileUtil.getSuffix(filename.getName());
    }

    public static String getSuffix(String filename) {
        return filename.substring(filename.lastIndexOf(46) + 1);
    }

    public static String getBasename(File file) {
        return FileUtil.getBasename(file.getAbsolutePath());
    }

    public static String getBasename(String filename) {
        if (filename == null || filename.lastIndexOf(46) == -1) {
            return null;
        }
        return filename.substring(0, filename.lastIndexOf(46));
    }

    public static String getSuffixReplacedFilePath(File file, String suffix) {
        String basename = FileUtil.getBasename(file);
        if (basename != null) {
            return String.valueOf(basename) + suffix;
        }
        return null;
    }

    public static void writeImageFile(File imageFile, BufferedImage bufferedImage) throws FileNotFoundException, IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(imageFile));
        ImageIO.write((RenderedImage)bufferedImage, "png", out);
        ((OutputStream)out).close();
    }

    public static PrintWriter createPrintWriter(OutputStream stream, String encoding) throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(stream), encoding));
    }

    public static PrintWriter createPrintWriter(File file, String encoding) throws IOException {
        return FileUtil.createPrintWriter(new FileOutputStream(file), encoding);
    }

    public static Reader createReader(InputStream input, String encoding) throws IOException {
        return new InputStreamReader((InputStream)new BufferedInputStream(input), encoding);
    }
}

