/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.rngom.binary;

import org.kohsuke.rngom.binary.Alphabet;
import org.kohsuke.rngom.binary.DuplicateAttributeDetector;
import org.kohsuke.rngom.binary.Pattern;
import org.kohsuke.rngom.binary.RestrictionViolationException;
import org.xml.sax.SAXException;

abstract class BinaryPattern
extends Pattern {
    Pattern p1;
    Pattern p2;

    BinaryPattern(boolean nullable, int hc, Pattern p1, Pattern p2) {
        super(nullable, Math.max(p1.getContentType(), p2.getContentType()), hc);
        this.p1 = p1;
        this.p2 = p2;
    }

    void checkRecursion(int depth) throws SAXException {
        this.p1.checkRecursion(depth);
        this.p2.checkRecursion(depth);
    }

    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        this.p1.checkRestrictions(context, dad, alpha);
        this.p2.checkRestrictions(context, dad, alpha);
    }

    boolean samePattern(Pattern other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        BinaryPattern b = (BinaryPattern)other;
        return this.p1 == b.p1 && this.p2 == b.p2;
    }

    Pattern getOperand1() {
        return this.p1;
    }

    Pattern getOperand2() {
        return this.p2;
    }
}

