<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2" xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs" version="1.0">

	<xsl:template match="xhtml2:table">
		<fo:table table-layout="fixed">
<!--			<xsl:call-template name="xhtml2:table"/>-->
<!--			<xsl:apply-templates/>-->
		</fo:table>
	</xsl:template>

	<xsl:template match="xhtml2:table[@xhtml2:class='question']">
		<fo:table id="{@id}" table-layout="fixed" xsl:use-attribute-sets="question"><!--page-break-before="avoid" -->
			<fo:table-column column-width="{$qid-label-width}px"/>
			<fo:table-column column-width="{$WIDTH - $qid-label-width}px"/>
			<xsl:apply-templates/>
		</fo:table>
	</xsl:template>

	<xsl:template match="xhtml2:table[@xhtml2:class='matrix-forms']">
 		<fo:table table-layout="fixed" xsl:use-attribute-sets="matrix-forms">
			<xsl:variable name="label-width" select="floor(($WIDTH - $qid-label-width - $qid2-label-width) * (1.0 - @sqs:form-width-ratio))"/>
			<xsl:variable name="form-width" select="floor(($WIDTH - $qid-label-width - $qid2-label-width) * (@sqs:form-width-ratio))"/>
			<fo:table-column column-width="{$qid2-label-width}px"/>
			<fo:table-column column-width="{$label-width}px"/>

			<xsl:variable name="textarea-width-total" select="sum(xhtml2:thead/xhtml2:tr[1]/xhtml2:th/@sqs:width)"/>
			<xsl:variable name="num-items" select="count(xhtml2:thead/xhtml2:tr[2]/xhtml2:th)"/>

			<xsl:for-each select="xhtml2:thead/xhtml2:tr[1]/xhtml2:th[1 &lt; position()]">
				<xsl:variable name="column-group-index" select="@sqs:column-group-index"/>
				<xsl:choose>
				<xsl:when test="@sqs:xforms-type='select1' or @sqs:xforms-type='select'">
					<xsl:for-each select="ancestor::xhtml2:thead/xhtml2:tr[2]/xhtml2:th[@sqs:column-group-index = $column-group-index]">
						<fo:table-column column-width="{floor(($form-width - $textarea-width-total) div $num-items )}px"/>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<fo:table-column column-width="{number(@sqs:width)}px"/>
				</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<xsl:apply-templates/>
		</fo:table>
	</xsl:template>
	<xsl:template match="xhtml2:table[@xhtml2:class='itemset']">
		<fo:table table-layout="fixed">
			<xsl:call-template name="xsl-function-loop">
				<xsl:with-param name="times">
					<xsl:value-of select="@sqs:cols"/>
				</xsl:with-param>
				<xsl:with-param name="value">
					<fo:table-column column-width="{floor(($WIDTH - $qid-label-width - $qid2-label-width) div number(@sqs:cols))}px"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:apply-templates/>
		</fo:table>
	</xsl:template>
	<xsl:template match="xhtml2:table[@xhtml2:class='item']">
		<fo:table table-layout="fixed">
			<fo:table-column column-width="{$item-form-width}px"/>
			<fo:table-column column-width="{$item-label-width}px"/>
			<fo:table-column column-width="{floor(number(parent::xhtml2:td/@xhtml2:colspan) * ($WIDTH - $qid-label-width - $qid2-label-width) div number(ancestor::xhtml2:table/@sqs:cols)) - $item-form-width - $item-label-width}px"/>
			<xsl:apply-templates/>
		</fo:table>
	</xsl:template>

	<xsl:template name="table-itemset">
		<!--        <xsl:comment>sqs:cols<xsl:value-of select="@sqs:cols"/></xsl:comment>-->
	</xsl:template>

	<xsl:template match="xhtml2:thead">
		<fo:table-header>
			<xsl:apply-templates/>
		</fo:table-header>
	</xsl:template>
	<xsl:template match="xhtml2:tbody">
		<fo:table-body>
			<xsl:apply-templates/>
		</fo:table-body>
	</xsl:template>
	<xsl:template match="xhtml2:tr">
		<xsl:choose>
			<xsl:when test="0 &lt; string-length(@id)">
				<xsl:element name="fo:table-row">
					<xsl:attribute name="keep-with-previous">always</xsl:attribute>
					<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="ancestor::xhtml2:table/@xhtml2:class = 'itemset' or ancestor::xhtml2:table/@xhtml2:class = 'question'">
				<xsl:element name="fo:table-row">
					<xsl:attribute name="keep-with-previous">always</xsl:attribute>
					<xsl:apply-templates select="@*|@xhtml2:*"/>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="fo:table-row">
					<xsl:apply-templates select="@*|@xhtml2:*"/>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="xhtml2:th">
		<xsl:variable name="number-columns-spanned"><xsl:choose><xsl:when test="0 = string-length(@xhtml2:colspan)">1</xsl:when><xsl:otherwise><xsl:value-of select="@xhtml2:colspan"/></xsl:otherwise></xsl:choose></xsl:variable>
		<xsl:variable name="number-rows-spanned"><xsl:choose><xsl:when test="0 = string-length(@xhtml2:rowspan)">1</xsl:when><xsl:otherwise><xsl:value-of select="@xhtml2:rowspan"/></xsl:otherwise></xsl:choose></xsl:variable>
		<xsl:choose>
			<xsl:when test="ancestor::xhtml2:table/@xhtml2:class = 'matrix-forms'">
				<fo:table-cell number-columns-spanned="{$number-columns-spanned}" number-rows-spanned="{$number-rows-spanned}" xsl:use-attribute-sets="matrix-forms-th">
					<fo:block xsl:use-attribute-sets="matrix-forms-th-block">
					<xsl:apply-templates/>
					</fo:block>
				</fo:table-cell>
			</xsl:when>
			<xsl:otherwise>
				<fo:table-cell number-columns-spanned="{$number-columns-spanned}" number-rows-spanned="{$number-rows-spanned}">
					<fo:block>
					<xsl:apply-templates/>
					</fo:block>
				</fo:table-cell>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="xhtml2:td">
		<xsl:choose>
			<xsl:when test="@xhtml2:class='matrix-forms-column-set'">
				<xsl:choose>
					<xsl:when test="@sqs:column-start = 'true'">
					<fo:table-cell xsl:use-attribute-sets="td-block.matrix-forms-column-set-start">
					<fo:block>
						<xsl:apply-templates/>
					</fo:block>
					</fo:table-cell>
					</xsl:when>
					<xsl:otherwise>
					<fo:table-cell xsl:use-attribute-sets="td-block.matrix-forms-column-set">
					<fo:block>
						<xsl:apply-templates/>
					</fo:block>
					</fo:table-cell>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<xsl:when test="@xhtml2:class='matrix-forms-label'">
				<fo:table-cell xsl:use-attribute-sets="td-block.matrix-forms-label">
					<fo:block>
						<xsl:apply-templates/>
					</fo:block>
				</fo:table-cell>
			</xsl:when>

			<xsl:when test="@xhtml2:class='matrix-forms-td'">
				<fo:table-cell xsl:use-attribute-sets="matrix-forms-td">
					<fo:block>
						<xsl:apply-templates/>
					</fo:block>
				</fo:table-cell>
			</xsl:when>

			<xsl:when test="@xhtml2:class='item-form'">
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="td-block.item-form">
						<xsl:apply-templates/>
					</fo:block>
				</fo:table-cell>
			</xsl:when>
			<xsl:when test="@xhtml2:class='item-value'">
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="td-block.item-value">
						<xsl:apply-templates/>
					</fo:block>
				</fo:table-cell>
			</xsl:when>
			<xsl:when test="@xhtml2:class='item-label'">
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="td-block.item-label">
						<xsl:apply-templates/>
					</fo:block>
				</fo:table-cell>
			</xsl:when>
			<xsl:when test="1 &lt; @xhtml2:colspan">
				<fo:table-cell number-columns-spanned="{@xhtml2:colspan}">
					<fo:block xsl:use-attribute-sets="td-block">
						<xsl:apply-templates/>
					</fo:block>
				</fo:table-cell>
			</xsl:when>
			<xsl:otherwise>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="td-block">
						<xsl:apply-templates/>
					</fo:block>
				</fo:table-cell>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
