/*

 TreeNodePopupMenu.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/10

 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.List;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

class TreeNodePopupMenu extends JPopupMenu{
    private final NodeTreePane treePane;
    private TreeNodePopupAdapter listener;
    private JMenuItem cutMenuItem, copyMenuItem;

    TreeNodePopupMenu(NodeTreePane tree, int rowIndex){
        this.treePane = tree;
        listener = new TreeNodePopupAdapter(this);

        JMenuItem showAllMenuItem = createPopupMenuItem("選択したノードの「枝を表示」", "S "+rowIndex);
        JMenuItem hideAllMenuItem = createPopupMenuItem("選択したノードの「枝を隠す」", "H "+rowIndex);

        add(showAllMenuItem);
        add(hideAllMenuItem);
        addSeparator();

        this.cutMenuItem = createPopupMenuItem("選択したノードを「カット」", "d "+rowIndex);
        this.copyMenuItem = createPopupMenuItem("選択したノードを「コピー」", "c "+rowIndex);
        
        cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, ActionEvent.CTRL_MASK));
        copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK));
        
        if(isReadOnly()){
           cutMenuItem.setEnabled(false);
        }
        add(cutMenuItem);
        add(copyMenuItem);


        List recentCutNodes = tree.mediator.menuBarMediator.getRecentCutNode();
        if(recentCutNodes != null && 0 < recentCutNodes.size()){
            addSeparator();
            JMenuItem insertUpperMenu = createPopupMenuItem("↑  クリックしたノードの「前」に貼り付け", "b "+rowIndex);
            JMenuItem insertWithinMenu = createPopupMenuItem("→  クリックしたノードの「枝」として貼り付け", "i "+rowIndex);
            JMenuItem insertLowerMenu = createPopupMenuItem("↓  クリックしたノードの「後」に貼り付け", "a "+rowIndex);
            
            insertLowerMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, ActionEvent.CTRL_MASK));
            
            if(isReadOnly()){
                insertUpperMenu.setEnabled(false);
                insertWithinMenu.setEnabled(false);
                insertLowerMenu.setEnabled(false);
            }
            add(insertUpperMenu);
            add(insertWithinMenu);
            add(insertLowerMenu);
            setPopupSize(300,150);
        }else{
            setPopupSize(300,100);
        }
       
    }
    
    boolean isReadOnly() {
        return getTreePane().mediator.getSourceEditorTabbedPane().getCurrentEditingSource().isReadOnly();
    }

    public NodeTreePane getTreePane(){
        return treePane;
    }
    /*
    private JMenu createPopupMenu(String label, String command){
        JMenu menu = new JMenu(label);
        JMenuItem item = createPopupMenuItem("貼り付け", command);
        menu.add(item);
        return menu;
    }
    */
    private JMenuItem createPopupMenuItem(String label, String command){
        JMenuItem item = new JMenuItem(label);
        item.setActionCommand(command);
        item.addActionListener(listener);
        return item;
    }
    
    public JMenuItem getCutMenuItem(){
        return cutMenuItem;
    }
    
    public JMenuItem getCopyMenuItem(){
        return copyMenuItem;
    }
}