/*

 SQSSourceEditorMediator.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on Jul 20, 2004

 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.awt.BorderLayout;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.source.SourceManager;
import net.sf.sqs_xml.editor.base.swing.NodeTreePane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMenuBarMediator;
import net.sf.sqs_xml.editor.base.swing.SourceEditorSplitPane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorTabbedPane;
import net.sf.sqs_xml.editor.base.swing.SourceEditorToolBar;
import net.sf.sqs_xml.editor.sqs.source.SQSSourceManager;
import net.sf.sqs_xml.httpd.SourceEditorHttpd;
import net.sf.sqs_xml.swing.IconFactory;

/**
 * @author hiroya
 *
 */
public class SQSSourceEditorMediator extends SourceEditorMediator{
    public static final String TITLE = "SQS Source Editor(2004/10/28)";
    public static final String BASEURI = SourceEditorHttpd.getSingleton().getBase(); 
    JPanel backgroundPanel = null;
    static{
        IconFactory.setBaseURI(SourceEditorHttpd.getSingleton().getBase());
    }

    public String getTitle(){
        return TITLE;
    }

    public JPanel getBackgroundPanel(){
        if(backgroundPanel == null){
            backgroundPanel = new JPanel();
            backgroundPanel.setLayout(new BorderLayout());
            JLabel titleLabel = new JLabel("Shared Questionnaire System");
            titleLabel.setEnabled(false);
            Box titlePanel = Box.createHorizontalBox();
            titlePanel.add(titleLabel);
            titlePanel.add(new JLabel(IconFactory.create("wizard.gif")));
            backgroundPanel.add(titlePanel, BorderLayout.EAST);
        }
        return backgroundPanel;
    }
    
    public static void main(String[] args)throws Exception{
        /*
	    try{
	        new MarkReaderHttpd();
	    }catch(Error ignore){
	    }
	    */
	    if(args.length==0){
            new SQSSourceEditorMediator();
        }else if(args.length==1){
            URL url = null;
            try{
                url = new URL(args[0]);
                new SQSSourceEditorMediator(url);
            }catch(MalformedURLException ignore){
                new SQSSourceEditorMediator(new File(args[0]));
            }
        }
    }
    
    public SQSSourceEditorMediator(URL url)throws Exception{
        super(url);
    }
    
    public SQSSourceEditorMediator(File file)throws Exception{
        super(file);
    }
    
    public SQSSourceEditorMediator()throws Exception{
        super();
    }
    
    public SourceManager createSourceManager(){
        return new SQSSourceManager();
    }
    
    public SourceEditorMenuBarMediator createSourceEditorMenuBarMediator(){
        return new SQSSourceEditorMenuBarMediator(this);
    }
    
    public SourceEditorToolBar createSourceEditorToolBar(){
        return new SQSSourceEditorToolBar(this);
    }
    
    public SourceEditorTabbedPane createSourceEditorTabbedPane(final SourceEditorMediator mediator){
        return new SourceEditorTabbedPane(mediator){
            public SourceEditorSplitPane createSourceEditorSplitPane(final SourceEditorMediator mediator, DOMTreeSource source, int width){
                return new SourceEditorSplitPane(mediator, source, width){
                    public NodeTreePane createSourceEditorTree(final SourceEditorMediator mediator) {
                        return new SQSNodeTreePane(mediator, getSource(), getEditorPane());
                    }                    
                };
            }
            
            public Icon createTabIcon(DOMTreeSource source){
                return IconFactory.create("sqs-tiny.gif", "SQS Source");
            }
        };
    }

    /*
	chooser.setDialogTitle(outputFileDescription+"の保存");
	chooser.setSelectedFile(targetFile);
	chooser.addChoosableFileFilter(SwingUtil.createExtensionFileFilter(outputFileExtension, outputFileDescription));
*/
    
}
