/*

 FormFilter.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/11/01

 */
package net.sf.sqs_xml.httpd;

import java.util.List;

import net.sf.sqs_xml.util.StringUtil;
import net.sf.sqs_xml.xmlns.SQSNamespaces;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class FormFilter extends XMLFilterImpl{
    URLFilter filter;
    String tabindex;
    String action;
    String srcfile;
    List matrix;
    String name;
    int rowIndex = -1;
    
    public FormFilter(MicroHttpd httpd, String basePath, String action, String srcfile, List matrix){
        this.filter = new URLFilter(httpd, basePath);
        this.action = action;
        this.srcfile = srcfile;
        this.matrix = matrix;
    }
    
    public void startElement (String namespaceUri, String localName,
            String qualifiedName, Attributes attributes)throws SAXException{
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        if(localName.equals("img")){
            name = attributes.getValue("alt");
            filter.handleImage(attributes, attributesImpl);
        }else if(localName.equals("a")){
            tabindex = attributes.getValue("tabindex");
            filter.handleAnchor(attributes, attributesImpl);
        }else if(localName.equals("table")){
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute(SQSNamespaces.XHTML_URI, "method", "method", "CDATA", "POST");
            attr.addAttribute(SQSNamespaces.XHTML_URI, "action", "action", "CDATA", action);
            super.startElement(SQSNamespaces.XHTML_URI, "form", "form", attr);
        }
        super.startElement(namespaceUri, localName, qualifiedName, attributesImpl);
    }

    public void endElement (String namespaceUri, String localName,
            String qualifiedName)throws SAXException{
        super.endElement(namespaceUri, localName, qualifiedName);
        if(localName.equals("tr")){
            rowIndex++;
        }else if(localName.equals("a") && name != null){
            handleTextarea(name, rowIndex);
            name = null;
        }else if(localName.equals("table")){
            handleHidden(filter.basePath, srcfile);
            handleSubmit();
            super.endElement(SQSNamespaces.XHTML_URI, "form", "form");
        }else{
            
        }
    }

    private void handleTextarea(String name, int rowIndex) throws SAXException {
        super.startElement(SQSNamespaces.XHTML_URI, "p", "p", new AttributesImpl());
        int colIndex = Integer.parseInt(tabindex)+2;
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute(SQSNamespaces.XHTML_URI, "name", "name", "CDATA", colIndex+"-"+rowIndex);
        attr.addAttribute(SQSNamespaces.XHTML_URI, "cols", "cols", "CDATA", "45");
        attr.addAttribute(SQSNamespaces.XHTML_URI, "rows", "rows", "CDATA", "3");
        attr.addAttribute(SQSNamespaces.XHTML_URI, "tabindex", "tabindex", "CDATA", tabindex);
        super.startElement(SQSNamespaces.XHTML_URI, "textarea", "textarea", attr);
        List list = (List)matrix.get(rowIndex);
        //System.err.println("name:"+name);
        //System.err.println("(x,y)=("+colIndex+"/"+list.size()+","+rowIndex+"/"+matrix.size()+")");
        String value = (String)list.get(colIndex);
        char[] chars = (StringUtil.escapeHTML(value)).toCharArray();
        super.characters(chars, 0, chars.length);
        super.endElement(SQSNamespaces.XHTML_URI, "textarea", "textarea");
        super.endElement(SQSNamespaces.XHTML_URI, "p", "p");
    }

    private void handleSubmit() throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute(SQSNamespaces.XHTML_URI, "type", "type", "CDATA", "submit");
        attr.addAttribute(SQSNamespaces.XHTML_URI, "tabindex", "tabindex", "CDATA", "32767");
        attr.addAttribute(SQSNamespaces.XHTML_URI, "value", "value", "CDATA", "     更新     ");
        super.startElement(SQSNamespaces.XHTML_URI, "input", "input", attr);
        super.endElement(SQSNamespaces.XHTML_URI, "input", "input");
    }

    private void handleHidden(String dir, String src) throws SAXException {
        createHiddenInput("dir", dir);
        createHiddenInput("src", src);
    }

    private void createHiddenInput(String name, String value) throws SAXException {
        AttributesImpl attr = null;
        attr = new AttributesImpl();
        attr.addAttribute(SQSNamespaces.XHTML_URI, "type", "type", "CDATA", "hidden");
        attr.addAttribute(SQSNamespaces.XHTML_URI, "name", "name", "CDATA", name);
        attr.addAttribute(SQSNamespaces.XHTML_URI, "value", "value", "CDATA", value);
        super.startElement(SQSNamespaces.XHTML_URI, "input", "input", attr);
        super.endElement(SQSNamespaces.XHTML_URI, "input", "input");
    }
    
}