/*

 URLFilter.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/11/01

 */
package net.sf.sqs_xml.httpd;

import java.io.File;

import net.sf.sqs_xml.xmlns.SQSNamespaces;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;


public class URLFilter extends XMLFilterImpl{
    MicroHttpd httpd;
    String basePath;
    public URLFilter(MicroHttpd httpd, String basePath){
          
        this.httpd = httpd;
        this.basePath = basePath;
    }
      
    public void startElement (String namespaceUri, String localName,
                          String qualifiedName, Attributes attributes)throws SAXException{
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        if(localName.equals("a")){
            handleAnchor(attributes, attributesImpl);
        }else if(localName.equals("img")){
            handleImage(attributes, attributesImpl);
        }
        super.startElement(namespaceUri, localName, qualifiedName, attributesImpl);
    }
      
    void handleImage(Attributes attributes, AttributesImpl attributesImpl) {
        String srcValue = attributes.getValue("src");
        attributesImpl.setValue(attributes.getIndex("src"), getConvertedValue(srcValue));
    }

    void handleAnchor(Attributes attributes, AttributesImpl attributesImpl) {
        if(0 <= attributes.getIndex("href")){
            String hrefValue = attributes.getValue("href");
            if(! hrefValue.startsWith("http:") && ! hrefValue.startsWith("file:")){
                attributesImpl.setValue(attributes.getIndex("href"), getConvertedValue(hrefValue));
            }
        }
    }

    public String getConvertedValue(String value){
          return httpd.getURL(new File(basePath+File.separator+value)).toString();
    }
}