/*

 MatrixDataBuilder.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on Jul 29, 2004

 */
package net.sf.sqs_xml.reader.logic;
import java.io.File;
import java.util.List;

import javax.xml.transform.TransformerException;

/**
 * @author hiroya
 *
 */

public class MatrixBuilder extends AbstractMatrixBuilder{
    protected QuestionnaireSchema schema;
    private List currentRowFileList;
    public MatrixBuilder(){
    }
    
    public void setQuestionnaireSchema(QuestionnaireSchema schema){
        this.schema = schema;        
    }
    
    public void setRowSize(int size){
        this.matrix = new Object[size];
    }
   
    public void addRowFileList(List rowFileList){
        this.rowFileList.add(rowFileList);
        currentRowFileList = rowFileList;
    }

    public void addRowFile(File rowFile){
        this.currentRowFileList.add(rowFile);
    }
    
    public void setMatrix(int index, Object[] line){
        this.matrix[index] = line;
    }

    public List getColumnNames(){
        return this.schema.columnNames;
    }
    
    public int getPage(String id){
        try{
            return schema.getPage(id);
        }catch(TransformerException ex){
            return -1;
        }
    }
}
