/*

 ProcessingInfoMappter.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/06

 */
package net.sf.sqs_xml.reader.logic;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author hiroya
 *
 */
public class ProcessingInfoMapper {
    Map errorAreaMap = new LinkedHashMap();
    Map validFileIndexToRealFileIndexMap = new HashMap();
    Map realFileIndexToValidFileIndexMap = new HashMap();
    int numErrorPages, numErrorMarkSets;
        
    public int getValidFileIndexSize(){
        return validFileIndexToRealFileIndexMap.size();
    }
    public void addErrorArea(int validFileIndex, int page, String qid){
        Integer index = new Integer(validFileIndex);
        List list = (List)errorAreaMap.get(index);
        if(list == null){
            list = new LinkedList();
            errorAreaMap.put(index, list);
        }
        list.add(new Object[]{new Integer(page), qid});
    }
    public Set getErrorAreaEntrySet(){
        return errorAreaMap.entrySet();
    }

    public void reset(){
        errorAreaMap.clear();
        validFileIndexToRealFileIndexMap.clear();
        realFileIndexToValidFileIndexMap.clear();
        numErrorPages = 0;
        numErrorMarkSets = 0;
    }
    public void addRealValidFileIndex(int realValidFileIndex){
        Integer realFileIndexObject = new Integer(realValidFileIndex);
        Integer validFileIndexObject = new Integer(validFileIndexToRealFileIndexMap.size());
        validFileIndexToRealFileIndexMap.put(validFileIndexObject, realFileIndexObject);
        realFileIndexToValidFileIndexMap.put(realFileIndexObject, validFileIndexObject);
    }
    public boolean isValidFileIndex(int realFileIndex){
        return realFileIndexToValidFileIndexMap.containsKey(new Integer(realFileIndex));
    }
    public int getRealFileIndex(int validFileIndex){
        return ((Integer)validFileIndexToRealFileIndexMap.get(new Integer(validFileIndex))).intValue();
    }
    public int getValidFileIndex(int realFileIndex){
        return ((Integer)realFileIndexToValidFileIndexMap.get(new Integer(realFileIndex))).intValue();
    }
    
    public void incrementNumErrorPages(){
        numErrorPages++;
    }
    public void incrementNumErrorMarkSets(){
        numErrorMarkSets++;
    }
    
    public void setNumErrorPages(int numErrorPages){
        this.numErrorPages = numErrorPages;
    }
    
    public int getNumErrorPages(){
        return this.numErrorPages;
    }

    public int getNumErrorMarkSets(){
        return this.numErrorMarkSets;
    }

}
