/*

 ReaderSourceTranslated.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/07/16

 */
package net.sf.sqs_xml.reader.logic;

import java.awt.geom.Point2D;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

import net.sf.sqs_xml.image.ImageTranslationFilter;
import net.sf.sqs_xml.image.RasterSource;

import org.apache.avalon.framework.logger.Logger;

/**
 * @author hiroya
 *
 */
public class ReaderSourceTranslated extends ImageTranslationFilter {
    public static final int UPPER_EXTENT = -3;
    public static final int LOWER_EXTENT = -2;
    public static final int LEFT_EXTENT =  2;
    public static final int RIGHT_EXTENT = 4;
    private boolean[][] data = null;
    private Logger logger = null;
    
    public ReaderSourceTranslated(RasterSource source, Point2D[] master, Point2D[] guide, int threshold){
        super(source, master, guide);
        setThreshold(threshold);
    }
    
    public ReaderSourceTranslated(RasterSource source, Point2D[] master, Point2D[] guide, int threshold, Logger logger){
        this(source, master, guide, threshold);
        this.logger = logger; 
    }
 
    public ReaderSourceTranslated(Raster raster, Point2D[] master, Point2D[] guide,
            int threshold){
        super(raster, master, guide);
        setThreshold(threshold);
    }
 
    public ReaderSourceTranslated(Raster raster, Point2D[] master, Point2D[] guide,
            int threshold, Logger logger){
        this(raster, master, guide, threshold);
        this.logger = logger; 
    }
 
	
	public Raster cropRaster(Rectangle rect){
	    return this.cropRaster(rect.x, rect.y, rect.width, rect.height); 
	}
	public Raster cropRaster(Rectangle rect, double scale){
	    return this.cropRaster(rect.x, rect.y, rect.width, rect.height, scale); 
	}

	public Raster cropRaster(int x, int y, int w, int h, double scale){
		WritableRaster ret = createCompatibleWritableRaster((int)(w*scale), (int)(h*scale));
		Point2D p = new Point2D.Double();
		int[] color = new int[4];
		for (int j = 0; j < h*scale; j++) {
			for (int i = 0; i < w*scale; i++) {
				int argb = getRGBColor(x + i/scale, y + j/scale, p);
				color[0] = (argb>>24)&0xff;
				color[1] = (argb>>16)&0xff;
				color[2] = (argb>>8)&0xff;
				color[3] = argb&0xff;
				if(getNumBands() == 1){
					color[0] = 255 - color[0];
					color[1] = 255 - color[1];
					color[2] = 255 - color[2];
					color[3] = 255 - color[3];
				    ret.setPixel(i, j, color);
				}else{
				    ret.setPixel(i, j, color);					    
				}
			}
		}
		return ret;
	}
	
	public Raster cropRaster(int x, int y, int w, int h){
		WritableRaster ret = createCompatibleWritableRaster(w, h);
		Point2D p = new Point2D.Double();
		int[] color = new int[4];
		for (int j = 0; j < h; j++) {
			for (int i = 0; i < w; i++) {
				int argb = getRGBColor(x + i, y + j, p);
				color[0] = (argb>>24)&0xff;
				color[1] = (argb>>16)&0xff;
				color[2] = (argb>>8)&0xff;
				color[3] = argb&0xff;
				if(getNumBands() == 1){
				    color[0] = 255 - color[0];
				    color[1] = 255 - color[1];
				    color[2] = 255 - color[2];
				    color[3] = 255 - color[3];
				    ret.setPixel(i, j, color);
				}else{
				    ret.setPixel(i, j, color);
				}
			}
		}
		return ret;
	}

	double getDensity(Rectangle rect){
	    int w = rect.width + LEFT_EXTENT + RIGHT_EXTENT;
	    int h = rect.height + UPPER_EXTENT + LOWER_EXTENT;
	    Point2D p = new Point2D.Double();
	    if(data == null){
	        data = new boolean[h][w]; 
	    }
        char[] message = null;
        for(int y = 0 ; y < h ; y++){
            message = new char[w]; 
            for(int x = 0; x < w; x++){
                if(data[y][x] = isBlack(getRGBColor(rect.x - LEFT_EXTENT + x,
					     						 	rect.y - UPPER_EXTENT + y))){
                    message[x] = 'o';
                }else{
                    message[x] = '-';
                }
            }
            /*
            if(logger != null){
                logger.debug(String.valueOf(message));
            }
            */
        }
        /*
        if(logger != null){
            logger.debug("");
        }*/
        int density = 0;
        for(int y = 1; y < h - 1; y++){
            message = new char[w-1];
            message[0] = ' ';
            for(int x = 1; x < w - 1; x++){
                if(getPixelThroughFilter(x, y)){
                    message[x] = '*';
                    density++;
                }else{
                    message[x] = '-';
                }
            }
            //logger.debug(String.valueOf(message));
        }
        return 1.0 * density / ( (w-2) * (h-2));
    }
    
    //new NoiseCancelFilter(2, 10, 12);

    final boolean getPixelThroughFilter(int x, int y) {
        boolean target = false;
        int numBlackPixel = 0;
        for (int j = -1; j <= 1; j++) {
            for (int i = -1; i <= 1; i++) {
                boolean color = data[y+j][x+i];
                if (i == 0 && j == 0) {
                    target = color;
                } else {
                    numBlackPixel += color ? 1 : 0;
                }
            }
        }

        if (target) {
            if (numBlackPixel <= 2) {
                return false;
            }
        } else {
            if (8 <= numBlackPixel) {
                return true;
            }
        }
        return target;
    }
 
    void translatePointArray(Point2D[] markRectCorners, Rectangle rect) {
        markRectCorners[0] = getPoint(rect.x, rect.y, 1.0, markRectCorners[0]);
        markRectCorners[1] = getPoint(rect.x+rect.width, rect.y, 1.0, markRectCorners[1]);
        markRectCorners[2] = getPoint(rect.x, rect.y+rect.height, 1.0, markRectCorners[2]);
        markRectCorners[3] = getPoint(rect.x+rect.width, rect.y+rect.height, 1.0, markRectCorners[3]);
    }

}
