/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package net.sf.sqs_xml.reader.model;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Page</b> is generated from reader.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="page" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader">
 *                   <attribute name="sampleID">
 * 						<data type="int"/>
 * 	              </attribute>      
 *                   <attribute name="number">
 * 						<data type="int"/>
 * 	              </attribute>                   
 * 
 *                   <optional>
 *                     <ref name="FormElements"/>
 *                   </optional>
 * 
 *                 </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="page" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader"&gt;
 *                   &lt;attribute name="sampleID"&gt;
 * 						&lt;data type="int"/&gt;
 * 	              &lt;/attribute&gt;      
 *                   &lt;attribute name="number"&gt;
 * 						&lt;data type="int"/&gt;
 * 	              &lt;/attribute&gt;                   
 * 
 *                   &lt;optional&gt;
 *                     &lt;ref name="FormElements"/&gt;
 *                   &lt;/optional&gt;
 * 
 *                 &lt;/element&gt;</pre>
 *
 * @version reader.rng (Fri Aug 06 03:48:33 GMT+09:00 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class Page implements java.io.Serializable, Cloneable, IRNSContainer, IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
    private int sampleID_;
    private int number_;
    // List<IFormElementsChoice>
    private java.util.List formElements_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>Page</code>.
     *
     */
    public Page() {
    }

    /**
     * Creates a <code>Page</code>.
     *
     * @param source
     */
    public Page(Page source) {
        setup(source);
    }

    /**
     * Creates a <code>Page</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Page(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Page</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Page(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Page</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Page(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Page</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Page(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Page</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Page(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Page</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Page(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Page</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Page(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Page</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Page(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Page</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Page(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Page</code> by the Page <code>source</code>.
     *
     * @param source
     */
    public void setup(Page source) {
        int size;
        sampleID_ = source.sampleID_;
        number_ = source.number_;
        this.formElements_.clear();
        size = source.formElements_.size();
        for (int i = 0;i < size;i++) {
            addFormElements((IFormElementsChoice)source.getFormElements(i).clone());
        }
    }

    /**
     * Initializes the <code>Page</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Page</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Page</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        sampleID_ = URelaxer.getAttributePropertyAsInt(element, "sampleID");
        number_ = URelaxer.getAttributePropertyAsInt(element, "number");
        formElements_.clear();
        while (true) {
            if (FormElementsMarkarea.isMatch(stack)) {
                addFormElements(new FormElementsMarkarea(stack));
            } else if (FormElementsTextarea.isMatch(stack)) {
                addFormElements(new FormElementsTextarea(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new Page((Page)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "page");
        rNSContext_.setupNamespace(element);
        int size;
        URelaxer.setAttributePropertyByInt(element, "sampleID", this.sampleID_);
        URelaxer.setAttributePropertyByInt(element, "number", this.number_);
        size = this.formElements_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Page</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Page</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>Page</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>Page</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>Page</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>Page</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the int property <b>sampleID</b>.
     *
     * @return int
     */
    public int getSampleID() {
        return (sampleID_);
    }

    /**
     * Sets the int property <b>sampleID</b>.
     *
     * @param sampleID
     */
    public void setSampleID(int sampleID) {
        this.sampleID_ = sampleID;
    }

    /**
     * Gets the int property <b>number</b>.
     *
     * @return int
     */
    public int getNumber() {
        return (number_);
    }

    /**
     * Sets the int property <b>number</b>.
     *
     * @param number
     */
    public void setNumber(int number) {
        this.number_ = number;
    }

    /**
     * Gets the IFormElementsChoice property <b>FormElements</b>.
     *
     * @return IFormElementsChoice[]
     */
    public IFormElementsChoice[] getFormElements() {
        IFormElementsChoice[] array = new IFormElementsChoice[formElements_.size()];
        return ((IFormElementsChoice[])formElements_.toArray(array));
    }

    /**
     * Sets the IFormElementsChoice property <b>FormElements</b>.
     *
     * @param formElements
     */
    public void setFormElements(IFormElementsChoice[] formElements) {
        this.formElements_.clear();
        for (int i = 0;i < formElements.length;i++) {
            addFormElements(formElements[i]);
        }
        for (int i = 0;i < formElements.length;i++) {
            formElements[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IFormElementsChoice property <b>FormElements</b>.
     *
     * @param formElements
     */
    public void setFormElements(IFormElementsChoice formElements) {
        this.formElements_.clear();
        addFormElements(formElements);
        if (formElements != null) {
            formElements.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IFormElementsChoice property <b>FormElements</b>.
     *
     * @param formElements
     */
    public void addFormElements(IFormElementsChoice formElements) {
        this.formElements_.add(formElements);
        if (formElements != null) {
            formElements.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IFormElementsChoice property <b>FormElements</b>.
     *
     * @param formElements
     */
    public void addFormElements(IFormElementsChoice[] formElements) {
        for (int i = 0;i < formElements.length;i++) {
            addFormElements(formElements[i]);
        }
        for (int i = 0;i < formElements.length;i++) {
            formElements[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IFormElementsChoice property <b>FormElements</b>.
     *
     * @return int
     */
    public int sizeFormElements() {
        return (formElements_.size());
    }

    /**
     * Gets the IFormElementsChoice property <b>FormElements</b> by index.
     *
     * @param index
     * @return IFormElementsChoice
     */
    public IFormElementsChoice getFormElements(int index) {
        return ((IFormElementsChoice)formElements_.get(index));
    }

    /**
     * Sets the IFormElementsChoice property <b>FormElements</b> by index.
     *
     * @param index
     * @param formElements
     */
    public void setFormElements(int index, IFormElementsChoice formElements) {
        this.formElements_.set(index, formElements);
        if (formElements != null) {
            formElements.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IFormElementsChoice property <b>FormElements</b> by index.
     *
     * @param index
     * @param formElements
     */
    public void addFormElements(int index, IFormElementsChoice formElements) {
        this.formElements_.add(index, formElements);
        if (formElements != null) {
            formElements.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IFormElementsChoice property <b>FormElements</b> by index.
     *
     * @param index
     */
    public void removeFormElements(int index) {
        this.formElements_.remove(index);
    }

    /**
     * Remove the IFormElementsChoice property <b>FormElements</b> by object.
     *
     * @param formElements
     */
    public void removeFormElements(IFormElementsChoice formElements) {
        this.formElements_.remove(formElements);
    }

    /**
     * Clear the IFormElementsChoice property <b>FormElements</b>.
     *
     */
    public void clearFormElements() {
        this.formElements_.clear();
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.append("<");
        URelaxer.makeQName(prefix, "page", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.append(" ");
        buffer.append("sampleID");
        buffer.append("=\"");
        buffer.append(URelaxer.getString(getSampleID()));
        buffer.append("\"");
        buffer.append(" ");
        buffer.append("number");
        buffer.append("=\"");
        buffer.append(URelaxer.getString(getNumber()));
        buffer.append("\"");
        size = this.formElements_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.formElements_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "page", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.write("<");
        URelaxer.makeQName(prefix, "page", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.write(" ");
        buffer.write("sampleID");
        buffer.write("=\"");
        buffer.write(URelaxer.getString(getSampleID()));
        buffer.write("\"");
        buffer.write(" ");
        buffer.write("number");
        buffer.write("=\"");
        buffer.write(URelaxer.getString(getNumber()));
        buffer.write("\"");
        size = this.formElements_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.formElements_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "page", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.print("<");
        URelaxer.makeQName(prefix, "page", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.print(" ");
        buffer.print("sampleID");
        buffer.print("=\"");
        buffer.print(URelaxer.getString(getSampleID()));
        buffer.print("\"");
        buffer.print(" ");
        buffer.print("number");
        buffer.print("=\"");
        buffer.print(URelaxer.getString(getNumber()));
        buffer.print("\"");
        size = this.formElements_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.formElements_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.formElements_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "page", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSampleIDAsString() {
        return (URelaxer.getString(getSampleID()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNumberAsString() {
        return (URelaxer.getString(getNumber()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSampleIDByString(String string) {
        setSampleID(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNumberByString(String string) {
        setNumber(Integer.parseInt(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(formElements_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Page</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "page")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "sampleID")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "number")) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (FormElementsMarkarea.isMatchHungry(target)) {
                $match$ = true;
            } else if (FormElementsTextarea.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Page</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Page</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
