/*

 ProgressLoggerConsoleFrame.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/19

 */
package net.sf.sqs_xml.reader.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
//import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import net.sf.sqs_xml.swing.IconFactory;
import net.sf.sqs_xml.swing.LoggerConsoleFrame;

import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;


/**
 * @author hiroya
 *
 */
public class ProgressLoggerConsoleFrame extends LoggerConsoleFrame {
    static Icon grayIcon = IconFactory.create("ball.gray.gif");
    static Icon blueIcon = IconFactory.create("ball.blue.gif");
    static Icon yellowIcon = IconFactory.create("ball.yellow.gif");
    static Icon redIcon = IconFactory.create("ball.red.gif");
    public ProgressLoggerConsoleFrame(String title,
            String cancelButtonLabel,
            String finishButtonLabel) {
        super(title, cancelButtonLabel, finishButtonLabel);
    }
    
    public Logger createLogger(String title){
        return new ConsoleLogger();
    }
    
    public static final String[] STEP_DESCRIPTION = new String[]{
          "PDFファイルの検出・PDFしおりの解析", 
          "処理対象となるスキャン画像ファイルの検出",
            "スキャン画像ファイルの更新日時の確認",
            "スキャン画像ファイルの読み取り位置の認識",
            "マーク欄の濃度読み取り・自由記述欄の画像ファイル切り出し",
          "回答者によって選択されたマークの抽出"
            };
    JPanel[] progressPanes;
    JPanel progressPane;
    JLabel[] data;
    int numPages;
    
    public void setBorderTitle(String title){
        progressPane.setBorder(new CompoundBorder(new EmptyBorder(5,5,5,5), new TitledBorder(new EtchedBorder(),
                "読み取り処理の進捗状況"+((title==null)?"":" : "+title))));
    }
    
    public void setPDFFile(File file, int numPages, int numColumns){
        this.numPages = numPages;
        data[0].setText(file.getAbsolutePath()+" ("+numPages+"ページ/設問カラム数: "+numColumns+")");
    }
    
    public void setPageNumberError(int numFiles, int numNumberOfPages){
        String message = "総ファイル数: "+numFiles+" ("+(numFiles/numPages)+"サンプル?) … ページ数が不正です:"+ (numPages - numFiles%numPages)+"個のファイル不足?";
        data[1].setText(message);
    }

    public void setNumFiles(int numFiles){
        data[1].setText("総ファイル数: "+numFiles+" ("+(numFiles/numPages)+"サンプル)");
    }

    public void setTargetFileCount(int numTargetFiles){
        data[2].setText("処理対象ファイル数: "+numTargetFiles);
    }
    
    public void setProcessedFile(int validFileIndex, int validFileTotal){
        data[3].setText("処理対象ファイル: " + validFileIndex + "/"+ validFileTotal);
    }
    public void setGuideError(int error, int validFileIndex, int validFileTotal){
        data[3].setText("■の列を正常に認識できなかったファイル数:"+error+" / 処理対象ファイル: " + validFileIndex + "/"+ validFileTotal);
    }
    
    public void setProcessedElements(int validFileIndex, int validFileTotal){
        data[4].setText("処理対象ファイル: " + validFileIndex + "/"+ validFileTotal);
    }
    
    public void setProcessedValues(int rowIndex, int numSamples){
        data[5].setText("処理対象サンプル: " + rowIndex + "/"+ numSamples);
    }
    /*
    public void setProcessedErrors(int rowIndex, int numSamples){
        data[6].setText("処理対象エラーサンプル: " + rowIndex + "/"+ numSamples);
    }
    */
    public void initialize(){
		progressPane = new JPanel();
		setBorderTitle(null);
		progressPane.setLayout(new BoxLayout(progressPane, BoxLayout.Y_AXIS));
		progressPane.add(Box.createVerticalStrut(10));
		progressPanes = new JPanel[STEP_DESCRIPTION.length];
		data = new JLabel[STEP_DESCRIPTION.length];
		createComponents();
		progressPane.setPreferredSize(new Dimension(700, 450));
		progressPane.add(Box.createVerticalStrut(5));
		progressPane.add(getBase());		
		
		
	    //getContentPane().setLayout(new BorderLayout());
		getContentPane().add(progressPane);//, BorderLayout.CENTER
		setSize(700, 450);
		//doLayout();
		setVisible(true);
	}

	private void createComponents() {
        for(int i=0; i<STEP_DESCRIPTION.length; i++){
            createComponents(i);   
		}
    }

    private void createComponents(int i) {
        JLabel stepItem[] = new JLabel[3];
        stepItem[0] = new JLabel(grayIcon);
        stepItem[1] = new JLabel(" Step "+(i+1)+" :");
        stepItem[2] = new JLabel(STEP_DESCRIPTION[i]);
        
        Box box1 = createStepItemComponents(stepItem);
        progressPanes[i] = new JPanel();
        progressPanes[i].setLayout(new BorderLayout());
        progressPanes[i].add(box1);
 
        data[i] = new JLabel("");
        data[i].setForeground(new Color(20, 20, 128));
        progressPane.add(progressPanes[i]);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(Box.createHorizontalStrut(20));
        box2.add(data[i]);
        box2.add(Box.createHorizontalStrut(20));
        progressPane.add(box2);
    }

    private Box createStepItemComponents(JLabel[] stepItem) {
        Box box1 = Box.createHorizontalBox();
        stepItem[0].setEnabled(false);
        stepItem[1].setEnabled(false);
        stepItem[2].setEnabled(false);
   
        box1.add(Box.createHorizontalStrut(30));
        box1.add(stepItem[0]);
        box1.add(stepItem[1]);
        box1.add(Box.createHorizontalStrut(15));
        box1.add(stepItem[2]);
        return box1;
    }

    public static final int NOT_PROCESSED = 0; 
	public static final int PROCESSING = 1; 
	public static final int SUCCEED = 2; 
	public static final int FAIL = 3; 
	
	public void setProgressState(int index, int mode){
	    JPanel progressPaneItem = progressPanes[index - 1];
	    JComponent box = (JComponent)progressPaneItem.getComponent(0);
	    if(mode == SUCCEED){
	        updateItem(box, index - 1, blueIcon);
	    }else if(mode == FAIL){
	        updateItem(box, index, redIcon);
	    }else if(mode == PROCESSING){
	        updateItem(box, index - 1, yellowIcon);
	    }
	}

    /**
     * @param isSuccess
     * @param box
     */
    private void updateItem(JComponent box, int index, Icon icon) {
        for(int i=0; i<box.getComponentCount(); i++){
	        JComponent part = (JComponent)box.getComponent(i);
	        if(i == 1){
	            JLabel iconLabel = ((JLabel)part);
	            if(iconLabel.getIcon().equals(redIcon)){
	                return;
	            }
	            iconLabel.setIcon(icon);
	        }
	        part.setEnabled(true);
	    }
    }

}
