/*
 * 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sf.sqs_xml.translator.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;

import org.apache.commons.fileupload.FileUploadBase;

public abstract class GenericTranslationServlet extends HttpServlet {

	public GenericTranslationServlet()throws Exception{
	}
	
	public void init(ServletConfig config)throws ServletException{
		super.init(config);
	}

	private void action(HttpServletRequest req, HttpServletResponse res)
		throws ServletException,IOException {
	    UploadedFile uf = FileUploadReceiver.receiveFileUpload(req, res, "sqs");
		req.setAttribute("fileNameBody", uf.getFileNameBody());
		req.setAttribute("fileInputStream", uf.getInputStream());
	}

    public void doGet(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {
		doPost(req, res);
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {
		try{
			action(req, res);
			perform(req, res);
			if (! FileUploadBase.isMultipartContent(req)) {
				((InputStream)req.getAttribute("sqsInputStream")).close();
			}
		}catch(TransformerException e){
			res.setContentType("text/plain");
			PrintWriter writer = new PrintWriter(res.getWriter());
			writer.println("ERROR!");
			writer.println(e.getLocationAsString()+" : "+e.getMessage());
			writer.close();
		}
	}

	public abstract void perform(HttpServletRequest req, HttpServletResponse res)throws ServletException, IOException, TransformerException;

}
