package org.kohsuke.rngom.dt.builtin;

import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.kohsuke.rngom.xml.util.WellKnownNamespaces;

class CompatibilityDatatypeLibrary implements DatatypeLibrary {
    private final DatatypeLibraryFactory factory;
    private DatatypeLibrary xsdDatatypeLibrary = null;

    CompatibilityDatatypeLibrary(DatatypeLibraryFactory factory) {
        this.factory = factory;
    }
    
    public DatatypeBuilder createDatatypeBuilder(String type)
        throws DatatypeException {
        if (BuiltinDatatypeLibrary.isXsdDatatype(type)) {
            if (xsdDatatypeLibrary == null) {
                xsdDatatypeLibrary =
                    factory.createDatatypeLibrary(
                        WellKnownNamespaces.XML_SCHEMA_DATATYPES);
                if (xsdDatatypeLibrary == null)
                    throw new DatatypeException();
            }
            return xsdDatatypeLibrary.createDatatypeBuilder(type);
        }
        throw new DatatypeException();
    }

    public Datatype createDatatype(String type) throws DatatypeException {
        return createDatatypeBuilder(type).createDatatype();
    }
}
