/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RunTest
extends Task {
    String basedir;
    String testsuite = "";
    String referenceJar = "";
    String refVersion = "";
    static /* synthetic */ Class class$0;

    public void setTestSuite(String str) {
        this.testsuite = str;
    }

    public void setBasedir(String str) {
        this.basedir = str;
    }

    public void setReference(String str) {
        this.referenceJar = str;
    }

    public void setRefVersion(String str) {
        this.refVersion = str;
    }

    public void execute() throws BuildException {
        this.runReference();
        this.testNewBuild();
    }

    protected void testNewBuild() {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{new URL("file:build/fop.jar")});
            HashMap diff = this.runConverter(loader, "areatree", "reference/output/");
            if (diff != null && !diff.isEmpty()) {
                System.out.println("====================================");
                System.out.println("The following files differ:");
                boolean broke = false;
                Iterator keys = diff.keySet().iterator();
                while (keys.hasNext()) {
                    Object fname = keys.next();
                    Boolean pass = (Boolean)diff.get(fname);
                    System.out.println("file: " + fname + " - reference success: " + pass);
                    if (!pass.booleanValue()) continue;
                    broke = true;
                }
                if (broke) {
                    throw new BuildException("Working tests have been changed.");
                }
            }
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
    }

    protected void runReference() throws BuildException {
        File f = new File(String.valueOf(this.basedir) + "/reference/output/");
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{new URL("file:" + this.referenceJar)});
            boolean failed = false;
            try {
                Class<?> cla = Class.forName("org.apache.fop.apps.Options", true, loader);
                Object opts = cla.newInstance();
                cla = Class.forName("org.apache.fop.apps.Version", true, loader);
                Method get = cla.getMethod("getVersion", new Class[0]);
                if (!get.invoke(null, new Object[0]).equals(this.refVersion)) {
                    throw new BuildException("Reference jar is not correct version it must be: " + this.refVersion);
                }
            }
            catch (IllegalAccessException iae) {
                failed = true;
            }
            catch (IllegalArgumentException are) {
                failed = true;
            }
            catch (InvocationTargetException are) {
                failed = true;
            }
            catch (ClassNotFoundException are) {
                failed = true;
            }
            catch (InstantiationException are) {
                failed = true;
            }
            catch (NoSuchMethodException are) {
                failed = true;
            }
            if (failed) {
                throw new BuildException("Reference jar could not be found in: " + this.basedir + "/reference/");
            }
            f.mkdirs();
            this.runConverter(loader, "reference/output/", null);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
    }

    protected HashMap runConverter(ClassLoader loader, String dest, String compDir) {
        String converter = "org.apache.fop.tools.TestConverter";
        HashMap diff = null;
        try {
            Class<?> cla = Class.forName(converter, true, loader);
            Object tc = cla.newInstance();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method meth = cla.getMethod("setBaseDir", classArray);
            meth.invoke(tc, this.basedir);
            Class[] classArray2 = new Class[3];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz2;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[1] = clazz3;
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[2] = clazz4;
            meth = cla.getMethod("runTests", classArray2);
            diff = (HashMap)meth.invoke(tc, this.testsuite, dest, compDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return diff;
    }
}

