/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfRectangle;

public class PdfPage
extends PdfDictionary {
    public static final PdfNumber PORTRAIT = new PdfNumber(0);
    public static final PdfNumber LANDSCAPE = new PdfNumber(90);
    public static final PdfNumber INVERTEDPORTRAIT = new PdfNumber(180);
    public static final PdfNumber SEASCAPE = new PdfNumber(270);
    PdfRectangle mediaBox;

    PdfPage(PdfRectangle mediaBox, Rectangle cropBox, PdfIndirectReference resources, PdfNumber rotate) {
        super(PdfDictionary.PAGE);
        this.mediaBox = mediaBox;
        this.put(PdfName.MEDIABOX, mediaBox);
        this.put(PdfName.RESOURCES, resources);
        if (rotate != null) {
            this.put(PdfName.ROTATE, rotate);
        }
        if (cropBox != null) {
            this.put(PdfName.CROPBOX, new PdfRectangle(cropBox));
        }
    }

    PdfPage(PdfRectangle mediaBox, Rectangle cropBox, PdfDictionary resources, PdfNumber rotate) {
        super(PdfDictionary.PAGE);
        this.mediaBox = mediaBox;
        this.put(PdfName.MEDIABOX, mediaBox);
        this.put(PdfName.RESOURCES, resources);
        if (rotate != null) {
            this.put(PdfName.ROTATE, rotate);
        }
        if (cropBox != null) {
            this.put(PdfName.CROPBOX, new PdfRectangle(cropBox));
        }
    }

    PdfPage(PdfRectangle mediaBox, Rectangle cropBox, PdfIndirectReference resources) {
        this(mediaBox, cropBox, resources, null);
    }

    PdfPage(PdfRectangle mediaBox, Rectangle cropBox, PdfDictionary resources) {
        this(mediaBox, cropBox, resources, null);
    }

    public boolean isParent() {
        return false;
    }

    void add(PdfIndirectReference contents) {
        this.put(PdfName.CONTENTS, contents);
    }

    PdfRectangle rotateMediaBox() {
        this.mediaBox = this.mediaBox.rotate();
        this.put(PdfName.MEDIABOX, this.mediaBox);
        return this.mediaBox;
    }

    PdfRectangle getMediaBox() {
        return this.mediaBox;
    }
}

