/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.fo.expr.PropertyException;

class PropertyTokenizer {
    static final int TOK_EOF = 0;
    static final int TOK_NCNAME = 1;
    static final int TOK_MULTIPLY = 2;
    static final int TOK_LPAR = 3;
    static final int TOK_RPAR = 4;
    static final int TOK_LITERAL = 5;
    static final int TOK_NUMBER = 6;
    static final int TOK_FUNCTION_LPAR = 7;
    static final int TOK_PLUS = 8;
    static final int TOK_MINUS = 9;
    static final int TOK_MOD = 10;
    static final int TOK_DIV = 11;
    static final int TOK_NUMERIC = 12;
    static final int TOK_COMMA = 13;
    static final int TOK_PERCENT = 14;
    static final int TOK_COLORSPEC = 15;
    static final int TOK_FLOAT = 16;
    static final int TOK_INTEGER = 17;
    int currentToken = 0;
    String currentTokenValue = null;
    protected int currentUnitLength = 0;
    private int currentTokenStartIndex = 0;
    private String expr;
    private int exprIndex = 0;
    private int exprLength;
    private boolean recognizeOperator = false;
    private static final int CS = 1;
    private static final int nameStartChars = 1;
    private static final int C = 2;
    private static final int nameChars = 2;
    private static final int D = 4;
    private static final int digits = 4;
    private static final int H = 8;
    private static final int hexchars = 8;
    private static final int C_CS = 3;
    private static final int[] charMap;

    static {
        int[] nArray = new int[128];
        nArray[45] = 2;
        nArray[46] = 2;
        nArray[48] = 14;
        nArray[49] = 14;
        nArray[50] = 14;
        nArray[51] = 14;
        nArray[52] = 14;
        nArray[53] = 14;
        nArray[54] = 14;
        nArray[55] = 14;
        nArray[56] = 14;
        nArray[57] = 14;
        nArray[65] = 9;
        nArray[66] = 9;
        nArray[67] = 9;
        nArray[68] = 9;
        nArray[69] = 9;
        nArray[70] = 9;
        nArray[71] = 1;
        nArray[72] = 1;
        nArray[73] = 1;
        nArray[74] = 1;
        nArray[75] = 1;
        nArray[76] = 1;
        nArray[77] = 1;
        nArray[78] = 1;
        nArray[79] = 1;
        nArray[80] = 1;
        nArray[81] = 1;
        nArray[82] = 1;
        nArray[83] = 1;
        nArray[84] = 1;
        nArray[85] = 1;
        nArray[86] = 1;
        nArray[87] = 1;
        nArray[88] = 1;
        nArray[89] = 1;
        nArray[90] = 1;
        nArray[95] = 1;
        nArray[97] = 9;
        nArray[98] = 9;
        nArray[99] = 9;
        nArray[100] = 9;
        nArray[101] = 9;
        nArray[102] = 9;
        nArray[103] = 1;
        nArray[104] = 1;
        nArray[105] = 1;
        nArray[106] = 1;
        nArray[107] = 1;
        nArray[108] = 1;
        nArray[109] = 1;
        nArray[110] = 1;
        nArray[111] = 1;
        nArray[112] = 1;
        nArray[113] = 1;
        nArray[114] = 1;
        nArray[115] = 1;
        nArray[116] = 1;
        nArray[117] = 1;
        nArray[118] = 1;
        nArray[119] = 1;
        nArray[120] = 1;
        nArray[121] = 1;
        nArray[122] = 1;
        charMap = nArray;
    }

    PropertyTokenizer(String s) {
        this.expr = s;
        this.exprLength = s.length();
    }

    void next() throws PropertyException {
        this.currentTokenValue = null;
        this.currentTokenStartIndex = this.exprIndex;
        boolean currentMaybeOperator = this.recognizeOperator;
        this.recognizeOperator = true;
        block13: while (true) {
            if (this.exprIndex >= this.exprLength) {
                this.currentToken = 0;
                return;
            }
            char c = this.expr.charAt(this.exprIndex++);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.currentTokenStartIndex = this.exprIndex;
                    continue block13;
                }
                case ',': {
                    this.recognizeOperator = false;
                    this.currentToken = 13;
                    return;
                }
                case '+': {
                    this.recognizeOperator = false;
                    this.currentToken = 8;
                    return;
                }
                case '-': {
                    this.recognizeOperator = false;
                    this.currentToken = 9;
                    return;
                }
                case '(': {
                    this.currentToken = 3;
                    this.recognizeOperator = false;
                    return;
                }
                case ')': {
                    this.currentToken = 4;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.exprIndex = this.expr.indexOf(c, this.exprIndex);
                    if (this.exprIndex < 0) {
                        this.exprIndex = this.currentTokenStartIndex + 1;
                        throw new PropertyException("missing quote");
                    }
                    this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex + 1, this.exprIndex++);
                    this.currentToken = 5;
                    return;
                }
                case '*': {
                    this.currentToken = 2;
                    return;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    boolean bSawDecimal;
                    this.scanDigits();
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '.') {
                        ++this.exprIndex;
                        bSawDecimal = true;
                        if (this.exprIndex < this.exprLength && PropertyTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
                            ++this.exprIndex;
                            this.scanDigits();
                        }
                    } else {
                        bSawDecimal = false;
                    }
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '%') {
                        ++this.exprIndex;
                        this.currentToken = 14;
                    } else {
                        this.currentUnitLength = this.exprIndex;
                        this.scanName();
                        this.currentUnitLength = this.exprIndex - this.currentUnitLength;
                        this.currentToken = this.currentUnitLength > 0 ? 12 : (bSawDecimal ? 16 : 17);
                    }
                    this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
                    return;
                }
                case '.': {
                    if (this.exprIndex < this.exprLength && PropertyTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
                        ++this.exprIndex;
                        this.scanDigits();
                        if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '%') {
                            ++this.exprIndex;
                            this.currentToken = 14;
                        } else {
                            this.currentUnitLength = this.exprIndex;
                            this.scanName();
                            this.currentUnitLength = this.exprIndex - this.currentUnitLength;
                            this.currentToken = this.currentUnitLength > 0 ? 12 : 16;
                        }
                        this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
                        return;
                    }
                    throw new PropertyException("illegal character '.'");
                }
                case '#': {
                    if (this.exprIndex < this.exprLength && PropertyTokenizer.isHexDigit(this.expr.charAt(this.exprIndex))) {
                        ++this.exprIndex;
                        this.scanHexDigits();
                        this.currentToken = 15;
                        this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
                        return;
                    }
                    throw new PropertyException("illegal character '#'");
                }
            }
            break;
        }
        --this.exprIndex;
        this.scanName();
        if (this.exprIndex == this.currentTokenStartIndex) {
            throw new PropertyException("illegal character");
        }
        this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
        if (this.currentTokenValue.equals("mod")) {
            this.currentToken = 10;
            return;
        }
        if (this.currentTokenValue.equals("div")) {
            this.currentToken = 11;
            return;
        }
        if (this.followingParen()) {
            this.currentToken = 7;
            this.recognizeOperator = false;
        } else {
            this.currentToken = 1;
            this.recognizeOperator = false;
        }
    }

    private void scanName() {
        if (this.exprIndex < this.exprLength && PropertyTokenizer.isNameStartChar(this.expr.charAt(this.exprIndex))) {
            while (++this.exprIndex < this.exprLength && PropertyTokenizer.isNameChar(this.expr.charAt(this.exprIndex))) {
            }
        }
    }

    private void scanDigits() {
        while (this.exprIndex < this.exprLength && PropertyTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
            ++this.exprIndex;
        }
    }

    private void scanHexDigits() {
        while (this.exprIndex < this.exprLength && PropertyTokenizer.isHexDigit(this.expr.charAt(this.exprIndex))) {
            ++this.exprIndex;
        }
    }

    private boolean followingParen() {
        int i = this.exprIndex;
        while (i < this.exprLength) {
            switch (this.expr.charAt(i)) {
                case '(': {
                    this.exprIndex = i + 1;
                    return true;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    private static final boolean isDigit(char c) {
        return c > '\u0000' && c < '\u0080' && (charMap[c] & 4) != 0;
    }

    private static final boolean isHexDigit(char c) {
        return c > '\u0000' && c < '\u0080' && (charMap[c] & 8) != 0;
    }

    private static final boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static final boolean isNameStartChar(char c) {
        return c >= '\u0080' || c < '\u0000' || (charMap[c] & 1) != 0;
    }

    private static final boolean isNameChar(char c) {
        return c > '\u0080' || c < '\u0000' || (charMap[c] & 3) != 0;
    }
}

