/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.ArrayList;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.render.Renderer;

public class Page {
    private int height;
    private int width;
    private BodyAreaContainer body;
    private AreaContainer before;
    private AreaContainer after;
    private AreaContainer start;
    private AreaContainer end;
    private AreaTree areaTree;
    private ArrayList rootExtensions;
    private PageSequence pageSequence;
    protected int pageNumber = 0;
    protected String formattedPageNumber;
    protected ArrayList linkSets = new ArrayList();
    private ArrayList idList = new ArrayList();
    private ArrayList footnotes = null;
    private ArrayList markers = null;

    Page(AreaTree areaTree, int height, int width) {
        this.areaTree = areaTree;
        this.height = height;
        this.width = width;
        this.markers = new ArrayList();
    }

    public IDReferences getIDReferences() {
        return this.areaTree.getIDReferences();
    }

    public void setPageSequence(PageSequence pageSequence) {
        this.pageSequence = pageSequence;
    }

    public PageSequence getPageSequence() {
        return this.pageSequence;
    }

    public AreaTree getAreaTree() {
        return this.areaTree;
    }

    public void setNumber(int number) {
        this.pageNumber = number;
    }

    public int getNumber() {
        return this.pageNumber;
    }

    public void setFormattedNumber(String number) {
        this.formattedPageNumber = number;
    }

    public String getFormattedNumber() {
        return this.formattedPageNumber;
    }

    void addAfter(AreaContainer area) {
        this.after = area;
        area.setPage(this);
    }

    void addBefore(AreaContainer area) {
        this.before = area;
        area.setPage(this);
    }

    public void addBody(BodyAreaContainer area) {
        this.body = area;
        area.setPage(this);
        area.getMainReferenceArea().setPage(this);
        area.getBeforeFloatReferenceArea().setPage(this);
        area.getFootnoteReferenceArea().setPage(this);
    }

    void addEnd(AreaContainer area) {
        this.end = area;
        area.setPage(this);
    }

    void addStart(AreaContainer area) {
        this.start = area;
        area.setPage(this);
    }

    public void render(Renderer renderer) {
        renderer.renderPage(this);
    }

    public AreaContainer getAfter() {
        return this.after;
    }

    public AreaContainer getBefore() {
        return this.before;
    }

    public AreaContainer getStart() {
        return this.start;
    }

    public AreaContainer getEnd() {
        return this.end;
    }

    public BodyAreaContainer getBody() {
        return this.body;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public FontInfo getFontInfo() {
        return this.areaTree.getFontInfo();
    }

    public void addLinkSet(LinkSet linkSet) {
        this.linkSets.add(linkSet);
    }

    public ArrayList getLinkSets() {
        return this.linkSets;
    }

    public boolean hasLinks() {
        return !this.linkSets.isEmpty();
    }

    public void addToIDList(String id) {
        this.idList.add(id);
    }

    public ArrayList getIDList() {
        return this.idList;
    }

    public ArrayList getPendingFootnotes() {
        return this.footnotes;
    }

    public ArrayList getExtensions() {
        return this.rootExtensions;
    }

    public void setExtensions(ArrayList extensions) {
        this.rootExtensions = extensions;
    }

    public void setPendingFootnotes(ArrayList v) {
        this.footnotes = v;
        if (this.footnotes != null) {
            int i = 0;
            while (i < this.footnotes.size()) {
                FootnoteBody fb = (FootnoteBody)this.footnotes.get(i);
                Footnote.layoutFootnote(this, fb, null);
                ++i;
            }
            this.footnotes = null;
        }
    }

    public void addPendingFootnote(FootnoteBody fb) {
        if (this.footnotes == null) {
            this.footnotes = new ArrayList();
        }
        this.footnotes.add(fb);
    }

    public void registerMarker(Marker marker) {
        this.markers.add(marker);
    }

    public void unregisterMarker(Marker marker) {
        this.markers.remove(marker);
    }

    public ArrayList getMarkers() {
        return this.markers;
    }
}

