/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.fonts.FontsResourceAnchor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

class Type1Font
extends BaseFont {
    private static FontsResourceAnchor resourceAnchor;
    protected byte[] pfb;
    private String FontName;
    private String FullName;
    private String FamilyName;
    private String Weight;
    private float ItalicAngle;
    private boolean IsFixedPitch;
    private String CharacterSet;
    private int llx;
    private int lly;
    private int urx;
    private int ury;
    private int UnderlinePosition;
    private int UnderlineThickness;
    private String EncodingScheme;
    private int CapHeight;
    private int XHeight;
    private int Ascender;
    private int Descender;
    private int StdHW;
    private int StdVW;
    private ArrayList CharMetrics;
    private HashMap KernPairs;
    private String fileName;
    private boolean builtinFont;
    private static final int[] pfbTypes;

    static {
        pfbTypes = new int[]{1, 2, 1};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Type1Font(String afmFile, String enc, boolean emb, byte[] ttfAfm, byte[] pfb) throws DocumentException, IOException {
        block28: {
            block29: {
                super();
                this.Weight = "";
                this.ItalicAngle = 0.0f;
                this.IsFixedPitch = false;
                this.llx = -50;
                this.lly = -200;
                this.urx = 1000;
                this.ury = 900;
                this.UnderlinePosition = -100;
                this.UnderlineThickness = 50;
                this.EncodingScheme = "FontSpecific";
                this.CapHeight = 700;
                this.XHeight = 480;
                this.Ascender = 800;
                this.Descender = -200;
                this.StdVW = 80;
                this.CharMetrics = new ArrayList<E>();
                this.KernPairs = new HashMap<K, V>();
                this.builtinFont = false;
                if (emb && ttfAfm != null && pfb == null) {
                    throw new DocumentException("Two byte arrays are needed if the Type1 font is embedded.");
                }
                if (emb && ttfAfm != null) {
                    this.pfb = pfb;
                }
                this.encoding = enc;
                this.embedded = emb;
                this.fileName = afmFile;
                this.fontType = 0;
                rf = null;
                is = null;
                if (!BaseFont.BuiltinFonts14.containsKey(afmFile)) break block29;
                this.embedded = false;
                this.builtinFont = true;
                buf = new byte[1024];
                try {
                    if (Type1Font.resourceAnchor == null) {
                        Type1Font.resourceAnchor = new FontsResourceAnchor();
                    }
                    if ((is = BaseFont.getResourceStream("com/lowagie/text/pdf/fonts/" + afmFile + ".afm", Type1Font.resourceAnchor.getClass().getClassLoader())) == null) {
                        msg = String.valueOf(afmFile) + " not found as resource. (The *.afm files must exist as resources in the package com.lowagie.text.pdf.fonts)";
                        System.err.println(msg);
                        throw new DocumentException(msg);
                    }
                    out = new ByteArrayOutputStream();
                    while (true) {
                        block30: {
                            if ((size = is.read(buf)) >= 0) break block30;
                            buf = out.toByteArray();
                            break;
                        }
                        out.write(buf, 0, size);
                    }
                }
                catch (Throwable var12_19) {
                    var11_20 = null;
                    if (is == null) throw var12_19;
                    try {
                        is.close();
                        throw var12_19;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw var12_19;
                }
                {
                    var11_21 = null;
                    if (is == null) ** GOTO lbl-1000
                }
                ** try [egrp 1[TRYBLOCK] [2 : 377->385)] { 
lbl62:
                // 1 sources

                is.close();
                ** GOTO lbl-1000
lbl64:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
lbl-1000:
                // 3 sources

                {
                    rf = new RandomAccessFileOrArray(buf);
                    this.process(rf);
                    var9_13 = null;
                    if (rf != null) {
                        try {
                            rf.close();
                        }
                        catch (Exception e) {}
                    }
                    break block28;
                }
            }
            if (afmFile.toLowerCase().endsWith(".afm") == false) throw new DocumentException(String.valueOf(afmFile) + " is not an AFM font file.");
            try {
                rf = ttfAfm == null ? new RandomAccessFileOrArray(afmFile) : new RandomAccessFileOrArray(ttfAfm);
                this.process(rf);
            }
            catch (Throwable var9_14) {
                buf = null;
                if (rf == null) throw var9_14;
                try {
                    rf.close();
                    throw var9_14;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw var9_14;
            }
            {
                buf = null;
                if (rf == null) break block28;
                try {}
                catch (Exception e) {}
                rf.close();
            }
        }
        try {
            this.EncodingScheme = this.EncodingScheme.trim();
            if (this.EncodingScheme.equals("AdobeStandardEncoding") || this.EncodingScheme.equals("StandardEncoding")) {
                this.fontSpecific = false;
            }
            PdfEncodings.convertToBytes(" ", enc);
            this.createEncoding();
            return;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new DocumentException(e);
        }
    }

    int getRawWidth(int c, String name) {
        try {
            if (name == null) {
                int k = 0;
                while (k < this.CharMetrics.size()) {
                    Object[] metrics = (Object[])this.CharMetrics.get(k);
                    if ((Integer)metrics[0] == c) {
                        return (Integer)metrics[1];
                    }
                    ++k;
                }
            } else {
                if (name.equals(".notdef")) {
                    return 0;
                }
                int k = 0;
                while (k < this.CharMetrics.size()) {
                    Object[] metrics = (Object[])this.CharMetrics.get(k);
                    if (name.equals(metrics[2])) {
                        return (Integer)metrics[1];
                    }
                    ++k;
                }
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        return 0;
    }

    public int getKerning(char char1, char char2) {
        String first = GlyphList.unicodeToName(char1);
        if (first == null) {
            return 0;
        }
        String second = GlyphList.unicodeToName(char2);
        if (second == null) {
            return 0;
        }
        Object[] obj = (Object[])this.KernPairs.get(first);
        if (obj == null) {
            return 0;
        }
        int k = 0;
        while (k < obj.length) {
            if (second.equals(obj[k])) {
                return (Integer)obj[k + 1];
            }
            k += 2;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void process(RandomAccessFileOrArray rf) throws DocumentException, IOException {
        isMetrics = false;
        while ((line = rf.readLine()) != null) {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("FontName")) {
                this.FontName = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("FullName")) {
                this.FullName = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("FamilyName")) {
                this.FamilyName = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("Weight")) {
                this.Weight = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("ItalicAngle")) {
                this.ItalicAngle = Float.valueOf(tok.nextToken()).floatValue();
                continue;
            }
            if (ident.equals("IsFixedPitch")) {
                this.IsFixedPitch = tok.nextToken().equals("true");
                continue;
            }
            if (ident.equals("CharacterSet")) {
                this.CharacterSet = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("FontBBox")) {
                this.llx = (int)Float.valueOf(tok.nextToken()).floatValue();
                this.lly = (int)Float.valueOf(tok.nextToken()).floatValue();
                this.urx = (int)Float.valueOf(tok.nextToken()).floatValue();
                this.ury = (int)Float.valueOf(tok.nextToken()).floatValue();
                continue;
            }
            if (ident.equals("UnderlinePosition")) {
                this.UnderlinePosition = (int)Float.valueOf(tok.nextToken()).floatValue();
                continue;
            }
            if (ident.equals("UnderlineThickness")) {
                this.UnderlineThickness = (int)Float.valueOf(tok.nextToken()).floatValue();
                continue;
            }
            if (ident.equals("EncodingScheme")) {
                this.EncodingScheme = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if (ident.equals("CapHeight")) {
                this.CapHeight = (int)Float.valueOf(tok.nextToken()).floatValue();
                continue;
            }
            if (ident.equals("XHeight")) {
                this.XHeight = (int)Float.valueOf(tok.nextToken()).floatValue();
                continue;
            }
            if (ident.equals("Ascender")) {
                this.Ascender = (int)Float.valueOf(tok.nextToken()).floatValue();
                continue;
            }
            if (ident.equals("Descender")) {
                this.Descender = (int)Float.valueOf(tok.nextToken()).floatValue();
                continue;
            }
            if (ident.equals("StdHW")) {
                this.StdHW = (int)Float.valueOf(tok.nextToken()).floatValue();
                continue;
            }
            if (ident.equals("StdVW")) {
                this.StdVW = (int)Float.valueOf(tok.nextToken()).floatValue();
                continue;
            }
            if (!ident.equals("StartCharMetrics")) continue;
            isMetrics = true;
            break;
        }
        if (isMetrics) ** GOTO lbl90
        throw new DocumentException("Missing StartCharMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("EndCharMetrics")) {
                isMetrics = false;
                break;
            }
            C = new Integer(-1);
            WX = new Integer(250);
            N = "";
            tok = new StringTokenizer(line, ";");
            while (tok.hasMoreTokens()) {
                tokc = new StringTokenizer(tok.nextToken());
                if (!tokc.hasMoreTokens()) continue;
                ident = tokc.nextToken();
                if (ident.equals("C")) {
                    C = Integer.valueOf(tokc.nextToken());
                    continue;
                }
                if (ident.equals("WX")) {
                    WX = new Integer(Float.valueOf(tokc.nextToken()).intValue());
                    continue;
                }
                if (!ident.equals("N")) continue;
                N = tokc.nextToken();
            }
            this.CharMetrics.add(new Object[]{C, WX, N});
lbl90:
            // 3 sources

            ** while ((line = rf.readLine()) != null)
        }
lbl91:
        // 2 sources

        if (!isMetrics) ** GOTO lbl101
        throw new DocumentException("Missing EndCharMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("EndFontMetrics")) {
                return;
            }
            if (!ident.equals("StartKernPairs")) continue;
            isMetrics = true;
            break;
lbl101:
            // 3 sources

            ** while ((line = rf.readLine()) != null)
        }
lbl102:
        // 2 sources

        if (isMetrics) ** GOTO lbl127
        throw new DocumentException("Missing EndFontMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            ident = tok.nextToken();
            if (ident.equals("KPX")) {
                first = tok.nextToken();
                second = tok.nextToken();
                width = new Integer(Float.valueOf(tok.nextToken()).intValue());
                relates = (Object[])this.KernPairs.get(first);
                if (relates == null) {
                    this.KernPairs.put(first, new Object[]{second, width});
                    continue;
                }
                n = relates.length;
                relates2 = new Object[n + 2];
                System.arraycopy(relates, 0, relates2, 0, n);
                relates2[n] = second;
                relates2[n + 1] = width;
                this.KernPairs.put(first, relates2);
                continue;
            }
            if (!ident.equals("EndKernPairs")) continue;
            isMetrics = false;
            break;
lbl127:
            // 5 sources

            ** while ((line = rf.readLine()) != null)
        }
lbl128:
        // 2 sources

        if (isMetrics) {
            throw new DocumentException("Missing EndKernPairs in " + this.fileName);
        }
        rf.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PdfStream getFontStream() throws DocumentException {
        if (this.builtinFont) return null;
        if (!this.embedded) {
            return null;
        }
        RandomAccessFileOrArray rf = null;
        try {
            try {
                String filePfb = String.valueOf(this.fileName.substring(0, this.fileName.length() - 3)) + "pfb";
                rf = this.pfb == null ? new RandomAccessFileOrArray(filePfb) : new RandomAccessFileOrArray(this.pfb);
                int fileLength = rf.length();
                byte[] st = new byte[fileLength - 18];
                int[] lengths = new int[3];
                int bytePtr = 0;
                int k = 0;
                block7: while (true) {
                    if (k >= 3) break;
                    if (rf.read() != 128) {
                        throw new DocumentException("Start marker missing in " + filePfb);
                    }
                    if (rf.read() != pfbTypes[k]) {
                        throw new DocumentException("Incorrect segment type in " + filePfb);
                    }
                    int size = rf.read();
                    size += rf.read() << 8;
                    size += rf.read() << 16;
                    lengths[k] = size += rf.read() << 24;
                    while (true) {
                        if (size == 0) {
                            ++k;
                            continue block7;
                        }
                        int got = rf.read(st, bytePtr, size);
                        if (got < 0) {
                            throw new DocumentException("Premature end in " + filePfb);
                        }
                        bytePtr += got;
                        size -= got;
                    }
                    break;
                }
                BaseFont.StreamFont streamFont = new BaseFont.StreamFont((BaseFont)this, st, lengths);
                Object var10_12 = null;
                if (rf == null) return streamFont;
                try {
                    rf.close();
                    return streamFont;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return streamFont;
            }
            catch (Exception e) {
                throw new DocumentException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (rf == null) throw throwable;
            try {}
            catch (Exception e2) {
                throw throwable;
            }
            rf.close();
            throw throwable;
        }
    }

    private PdfDictionary getFontDescriptor(PdfIndirectReference fontStream) {
        if (this.builtinFont) {
            return null;
        }
        PdfDictionary dic = new PdfDictionary(PdfName.FONTDESCRIPTOR);
        dic.put(PdfName.ASCENT, new PdfNumber(this.Ascender));
        dic.put(PdfName.CAPHEIGHT, new PdfNumber(this.CapHeight));
        dic.put(PdfName.DESCENT, new PdfNumber(this.Descender));
        dic.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        dic.put(PdfName.FONTNAME, new PdfName(this.FontName));
        dic.put(PdfName.ITALICANGLE, new PdfNumber(this.ItalicAngle));
        dic.put(PdfName.STEMV, new PdfNumber(this.StdVW));
        if (fontStream != null) {
            dic.put(PdfName.FONTFILE, fontStream);
        }
        int flags = 0;
        if (this.IsFixedPitch) {
            flags |= 1;
        }
        flags |= this.fontSpecific ? 4 : 32;
        if (this.ItalicAngle < 0.0f) {
            flags |= 0x40;
        }
        if (this.FontName.indexOf("Caps") >= 0 || this.FontName.endsWith("SC")) {
            flags |= 0x20000;
        }
        if (this.Weight.equals("Bold")) {
            flags |= 0x40000;
        }
        dic.put(PdfName.FLAGS, new PdfNumber(flags));
        return dic;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference fontDescriptor, int firstChar, int lastChar, byte[] shortTag) {
        boolean stdEncoding;
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
        dic.put(PdfName.BASEFONT, new PdfName(this.FontName));
        boolean bl = stdEncoding = this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman");
        if (!this.fontSpecific) {
            int k = firstChar;
            while (k <= lastChar) {
                if (!this.differences[k].equals(".notdef")) {
                    firstChar = k;
                    break;
                }
                ++k;
            }
            if (stdEncoding) {
                dic.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary enc = new PdfDictionary(PdfName.ENCODING);
                PdfArray dif = new PdfArray();
                boolean gap = true;
                int k2 = firstChar;
                while (k2 <= lastChar) {
                    if (shortTag[k2] != 0) {
                        if (gap) {
                            dif.add(new PdfNumber(k2));
                            gap = false;
                        }
                        dif.add(new PdfName(this.differences[k2]));
                    } else {
                        gap = true;
                    }
                    ++k2;
                }
                enc.put(PdfName.DIFFERENCES, dif);
                dic.put(PdfName.ENCODING, enc);
            }
        }
        if (this.forceWidthsOutput || !this.builtinFont || !this.fontSpecific && !stdEncoding) {
            dic.put(PdfName.FIRSTCHAR, new PdfNumber(firstChar));
            dic.put(PdfName.LASTCHAR, new PdfNumber(lastChar));
            PdfArray wd = new PdfArray();
            int k = firstChar;
            while (k <= lastChar) {
                if (shortTag[k] == 0) {
                    wd.add(new PdfNumber(0));
                } else {
                    wd.add(new PdfNumber(this.widths[k]));
                }
                ++k;
            }
            dic.put(PdfName.WIDTHS, wd);
        }
        if (!this.builtinFont && fontDescriptor != null) {
            dic.put(PdfName.FONTDESCRIPTOR, fontDescriptor);
        }
        return dic;
    }

    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
        int firstChar = (Integer)params[0];
        int lastChar = (Integer)params[1];
        byte[] shortTag = (byte[])params[2];
        if (!this.subset) {
            firstChar = 0;
            lastChar = shortTag.length - 1;
            int k = 0;
            while (k < shortTag.length) {
                shortTag[k] = 1;
                ++k;
            }
        }
        PdfIndirectReference ind_font = null;
        PdfDictionary pobj = null;
        PdfIndirectObject obj = null;
        pobj = this.getFontStream();
        if (pobj != null) {
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        if ((pobj = this.getFontDescriptor(ind_font)) != null) {
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        pobj = this.getFontBaseType(ind_font, firstChar, lastChar, shortTag);
        writer.addToBody((PdfObject)pobj, ref);
    }

    public float getFontDescriptor(int key, float fontSize) {
        switch (key) {
            case 1: 
            case 9: {
                return (float)this.Ascender * fontSize / 1000.0f;
            }
            case 2: {
                return (float)this.CapHeight * fontSize / 1000.0f;
            }
            case 3: 
            case 10: {
                return (float)this.Descender * fontSize / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return (float)this.llx * fontSize / 1000.0f;
            }
            case 6: {
                return (float)this.lly * fontSize / 1000.0f;
            }
            case 7: {
                return (float)this.urx * fontSize / 1000.0f;
            }
            case 8: {
                return (float)this.ury * fontSize / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (float)(this.urx - this.llx) * fontSize / 1000.0f;
            }
        }
        return 0.0f;
    }

    public String getPostscriptFontName() {
        return this.FontName;
    }

    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.FullName}};
    }

    public String[][] getFamilyFontName() {
        return new String[][]{{"", "", "", this.FamilyName}};
    }

    public boolean hasKernPairs() {
        return this.KernPairs.size() > 0;
    }
}

