/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.modules.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.panel.AbstractNodeEditorPanel;
import net.sf.sqs_xml.util.DOMUtil;
import org.w3c.dom.Node;

public abstract class AbstractSingleNodeEditorPanel
extends AbstractNodeEditorPanel {
    JTextArea nodeValueTextArea;
    JComponent nodeValueEditor;
    String previousValue = null;
    JPopupMenu popup;

    void showPopup(int x, int y) {
        this.popup.show(this.nodeValueTextArea, x, y);
    }

    public AbstractSingleNodeEditorPanel(AbstractNodeEditor editor) {
        super(editor);
        this.createPopupMenu();
        this.nodeValueTextArea = new JTextArea(3, 30);
        this.nodeValueTextArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3 && !AbstractSingleNodeEditorPanel.this.popup.isVisible()) {
                    AbstractSingleNodeEditorPanel.this.showPopup(e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && !AbstractSingleNodeEditorPanel.this.popup.isVisible()) {
                    AbstractSingleNodeEditorPanel.this.showPopup(e.getX(), e.getY());
                }
            }
        });
        this.nodeValueEditor = this.createNodeValueEditor(this.nodeValueTextArea);
        this.initNodeValueEditor(editor);
        this.add(this.nodeValueEditor);
        if (editor.getSource().isReadOnly()) {
            this.nodeValueTextArea.setEnabled(false);
        }
        this.initSize();
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem cutMenu = new JMenuItem("\u30ab\u30c3\u30c8    Ctrl-X");
        JMenuItem copyMenu = new JMenuItem("\u30b3\u30d4\u30fc    Ctrl-C");
        JMenuItem pasteMenu = new JMenuItem("\u8cbc\u308a\u4ed8\u3051  Ctrl-V");
        JMenuItem selectAllMenu = new JMenuItem("\u5168\u3066\u9078\u629e  Ctrl-A");
        cutMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AbstractSingleNodeEditorPanel.this.nodeValueTextArea.cut();
            }
        });
        copyMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AbstractSingleNodeEditorPanel.this.nodeValueTextArea.copy();
            }
        });
        pasteMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AbstractSingleNodeEditorPanel.this.nodeValueTextArea.paste();
            }
        });
        selectAllMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AbstractSingleNodeEditorPanel.this.nodeValueTextArea.selectAll();
            }
        });
        this.popup.add(cutMenu);
        this.popup.add(copyMenu);
        this.popup.add(pasteMenu);
        this.popup.addSeparator();
        this.popup.add(selectAllMenu);
    }

    private void initNodeValueEditor(AbstractNodeEditor editor) {
        if (editor.getNode() != null) {
            try {
                Node node = editor.getNode();
                this.previousValue = DOMUtil.stringValueOf(editor.getSource().getDocument(), node, this.getDescriptionXPath());
                this.nodeValueTextArea.setText(this.previousValue);
            }
            catch (ClassCastException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public JComponent createNodeValueEditor(JTextArea nodeValueTextArea) {
        Box nodeValueEditor = Box.createHorizontalBox();
        nodeValueEditor.add(new JScrollPane(nodeValueTextArea));
        nodeValueTextArea.addFocusListener(this.editor.getUpdateListener());
        return nodeValueEditor;
    }

    public abstract String getDescriptionXPath();

    public String getDescriptionLabel() {
        return "";
    }

    public boolean updateNodeValue() {
        if (this.previousValue == null || !this.previousValue.equals(this.nodeValueTextArea.getText())) {
            this.editor.updateNodeValue(this.getDescriptionXPath(), this.nodeValueTextArea.getText());
            return true;
        }
        return false;
    }
}

