/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.modules.panel;

import javax.swing.Box;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.EditorUtil;
import net.sf.sqs_xml.editor.base.modules.panel.AbstractNodeEditorPanel;

public class MatrixFormsWidthRatioPanel
extends AbstractNodeEditorPanel {
    static double DEFAULT_RATIO = 0.3;
    SpinnerModel ratioSpinnerModel;
    ChangeListener listener;
    Double ratio = this.getEditor().doubleValueOf("@sqs:form-width-ratio");

    public MatrixFormsWidthRatioPanel(AbstractNodeEditor editor) {
        super(editor);
        JSpinner ratioSpinner = this.createRatioSpinner(this.ratio);
        Box body = Box.createHorizontalBox();
        body.setBorder(new TitledBorder(EditorUtil.LOWERED_BORDER, "\u30ec\u30a4\u30a2\u30a6\u30c8"));
        Box ratioForm = EditorUtil.createSpinnerForm("\u56de\u7b54\u6b04\u90e8\u5206\u304c\u6a2a\u5e45\u5168\u4f53\u306b\u5360\u3081\u308b\u5272\u5408(0.0\u301c1.0):", ratioSpinner);
        if (editor.getSource().isReadOnly()) {
            ratioSpinner.setEnabled(false);
        }
        body.add(ratioForm);
        this.add(body);
        this.initSize();
    }

    public int getPreferredHeight() {
        return 40;
    }

    private JSpinner createRatioSpinner(Double ratio) {
        this.ratioSpinnerModel = this.createRatioModel(ratio);
        JSpinner ratioSpinner = new JSpinner(this.ratioSpinnerModel);
        ratioSpinner.addFocusListener(this.getEditor().getUpdateListener());
        ratioSpinner.addChangeListener(this.getEditor().getUpdateListener());
        return ratioSpinner;
    }

    private SpinnerNumberModel createRatioModel(Double value) {
        return new SpinnerNumberModel(value, 0.0, 1.0, 0.05);
    }

    public boolean updateNodeValue() {
        if (this.ratio == null || !this.ratio.equals(this.ratioSpinnerModel.getValue())) {
            this.getEditor().updateAttributeValue(".", "form-width-ratio", "http://sqs.cmr.sfc.keio.ac.jp/2004/sqs", this.ratioSpinnerModel.getValue());
            return true;
        }
        return false;
    }
}

