/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.sqs_xml.httpd.MarkReaderHttpd;
import net.sf.sqs_xml.reader.logic.BaseTaskSource;
import net.sf.sqs_xml.reader.logic.BaseTaskTarget;
import net.sf.sqs_xml.reader.logic.QuestionnaireSchema;
import net.sf.sqs_xml.reader.logic.ReaderProcessView;
import net.sf.sqs_xml.reader.logic.ReaderResultBuilder;
import net.sf.sqs_xml.reader.logic.ReaderTask;
import net.sf.sqs_xml.reader.logic.ReaderTaskSource;
import net.sf.sqs_xml.reader.logic.ReaderTaskTarget;
import net.sf.sqs_xml.reader.logic.ThreadSuspendingException;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.util.FileUtil;

abstract class ReaderBaseTask
extends ReaderTask {
    String textareaImageDirPath;
    String errorImageDirPath;
    InitQuestionnaireStructureTaskTarget initQuestionnaireStructureTaskTarget = new InitQuestionnaireStructureTaskTarget();
    FindImageFilesTaskTarget findImageFilesTaskTarget = new FindImageFilesTaskTarget();

    public abstract void processErrorImages() throws ThreadSuspendingException;

    public abstract void showResult();

    public abstract void save() throws TranslatorException, TransformerException, IOException, ParserConfigurationException, TransformerException, ThreadSuspendingException;

    public abstract void processCoreTasks() throws ThreadSuspendingException, TranslatorException, TransformerException;

    public abstract void checkImageFiles() throws ThreadSuspendingException, TranslatorException;

    public ReaderBaseTask(BaseTaskSource source, BaseTaskTarget target, ReaderProcessView view) {
        super(source, target, view);
    }

    public BaseTaskSource getSource() {
        return (BaseTaskSource)this.source;
    }

    public BaseTaskTarget getTarget() {
        return (BaseTaskTarget)this.target;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void run() throws Exception {
        System.err.println(new Date());
        try {
            try {
                this.process();
            }
            catch (TranslatorException ex) {
                this.processException(ex);
                this.processErrorImages();
                throw ex;
            }
            catch (TransformerException ex) {
                this.processException(ex);
            }
            catch (ParserConfigurationException ex) {
                this.processException(ex);
            }
            catch (IOException ex) {
                this.processException(ex);
            }
            catch (ThreadSuspendingException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            this.removeTextareaImageDirWhenEmpty();
            this.removeErrorImageDirWhenEmpty();
            this.showResult();
            System.err.println(new Date());
            throw throwable;
        }
        {
            Object var2_9 = null;
            this.removeTextareaImageDirWhenEmpty();
            this.removeErrorImageDirWhenEmpty();
            this.showResult();
            System.err.println(new Date());
            return;
        }
    }

    private void process() throws TranslatorException, TransformerException, ThreadSuspendingException, TransformerException, ParserConfigurationException, IOException {
        this.init();
        this.findImageFiles();
        this.checkImageFiles();
        this.processCoreTasks();
        this.processErrorImages();
        this.save();
        this.view.setSucceed();
    }

    private void init() throws TranslatorException {
        this.view.setImagedir(this.getSource().srcdir);
        this.checkPDFFileList();
        File pdffile = (File)this.getSource().pdffileList.get(0);
        this.view.setPDFFile(pdffile);
        this.initTextareaImageDir();
        this.initErrorImageDir();
        try {
            this.initQuestionnaireStructure(pdffile);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.view.throwIncorrectPDFException(pdffile);
        }
    }

    private void processException(Exception ex) throws Exception {
        ex.printStackTrace();
        this.view.errorDialog(ex, false);
    }

    private void checkPDFFileList() throws TranslatorException {
        if (this.getSource().pdffileList.size() == 0) {
            this.view.throwNoPDFException();
        } else if (1 < this.getSource().pdffileList.size()) {
            this.view.throwManyPDFException();
        }
    }

    private void initQuestionnaireStructure(File pdffile) throws Exception {
        new InitQuestionnaireStructureTask(new InitQuestionnaireStructureTaskSource(pdffile), this.initQuestionnaireStructureTaskTarget, this.view).run();
    }

    private void findImageFiles() throws TranslatorException {
        new FindImageFilesTask(new FindImageFilesTaskSource(this.getSource().srcdir, this.initQuestionnaireStructureTaskTarget.qSchema), this.findImageFilesTaskTarget, this.view).run();
    }

    private void initTextareaImageDir() {
        this.textareaImageDirPath = String.valueOf(this.getSource().tgtdir.getAbsolutePath()) + File.separator + "TEXTAREA";
        FileUtil.createDirectory(this.textareaImageDirPath);
        FileUtil.clearDirectory(this.textareaImageDirPath);
    }

    private void initErrorImageDir() {
        this.errorImageDirPath = String.valueOf(this.getSource().tgtdir.getAbsolutePath()) + File.separator + "ERROR";
        FileUtil.createDirectory(this.errorImageDirPath);
        FileUtil.clearDirectory(this.errorImageDirPath);
    }

    private void removeTextareaImageDirWhenEmpty() {
        try {
            new File(this.textareaImageDirPath).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeErrorImageDirWhenEmpty() {
        try {
            new File(this.errorImageDirPath).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void checkTaskStopRequest() throws ThreadSuspendingException {
        if (this.getTarget().state.taskStopRequested()) {
            throw new ThreadSuspendingException();
        }
        Thread.yield();
    }

    class InitQuestionnaireStructureTaskSource
    extends ReaderTaskSource {
        File pdffile;

        InitQuestionnaireStructureTaskSource(File pdffile) {
            this.pdffile = pdffile;
        }
    }

    class InitQuestionnaireStructureTaskTarget
    extends ReaderTaskTarget {
        QuestionnaireSchema qSchema;
        ReaderResultBuilder resultBuilder = new ReaderResultBuilder();

        InitQuestionnaireStructureTaskTarget() {
        }
    }

    class InitQuestionnaireStructureTask
    extends ReaderTask {
        InitQuestionnaireStructureTask(InitQuestionnaireStructureTaskSource source, InitQuestionnaireStructureTaskTarget target, ReaderProcessView view) {
            super(source, target, view);
        }

        public InitQuestionnaireStructureTaskSource getSource() {
            return (InitQuestionnaireStructureTaskSource)this.source;
        }

        public InitQuestionnaireStructureTaskTarget getTarget() {
            return (InitQuestionnaireStructureTaskTarget)this.target;
        }

        void run() throws Exception {
            this.view.setProgressState(1, 1);
            this.getTarget().qSchema = new QuestionnaireSchema(this.getSource().pdffile, MarkReaderHttpd.getSingleton().getBase());
            this.getTarget().resultBuilder.setQuestionnaireSchema(this.getTarget().qSchema);
            this.view.setPDFFileInfo(this.getSource().pdffile, this.getTarget().qSchema);
            this.view.setProgressState(1, 2);
        }
    }

    class FindImageFilesTask
    extends ReaderTask {
        FindImageFilesTask(FindImageFilesTaskSource source, FindImageFilesTaskTarget target, ReaderProcessView view) {
            super(source, target, view);
        }

        public FindImageFilesTaskSource getSource() {
            return (FindImageFilesTaskSource)this.source;
        }

        public FindImageFilesTaskTarget getTarget() {
            return (FindImageFilesTaskTarget)this.target;
        }

        void run() throws TranslatorException {
            this.view.setProgressState(2, 1);
            this.getTarget().fileList = FileUtil.find(this.getSource().imagedir, new FileFilter(this){
                final /* synthetic */ FindImageFilesTask this$1;
                {
                    this.this$1 = findImageFilesTask;
                }

                public boolean accept(File file) {
                    String filename = file.getName().toLowerCase();
                    return filename.endsWith(".tif") || filename.endsWith(".png") || filename.endsWith(".jpg") || filename.endsWith(".gif");
                }
            });
            int numFiles = this.getTarget().fileList.size();
            int numPages = this.getSource().qSchema.getNumberOfPages();
            this.view.initProgressBar(numFiles, numPages);
            if (numFiles % numPages == 0) {
                this.view.setFiles(numFiles);
            } else {
                this.view.setProgressState(2, 3);
                this.view.setPageSetError(numFiles, numPages);
                this.view.throwFileNumberError(numFiles, numPages);
            }
            this.view.setProgressState(2, 2);
        }
    }

    class FindImageFilesTaskSource
    extends ReaderTaskSource {
        File imagedir;
        QuestionnaireSchema qSchema;

        FindImageFilesTaskSource(File imagedir, QuestionnaireSchema qSchema) {
            this.imagedir = imagedir;
            this.qSchema = qSchema;
        }
    }

    class FindImageFilesTaskTarget
    extends ReaderTaskTarget {
        List fileList = null;

        FindImageFilesTaskTarget() {
        }
    }
}

