/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import net.sf.sqs_xml.image.ImageTranslationFilter;
import net.sf.sqs_xml.image.RasterSource;
import org.apache.avalon.framework.logger.Logger;

public class ReaderTranslatedSource
extends ImageTranslationFilter {
    public static final int UPPER_EXTENT = -3;
    public static final int LOWER_EXTENT = -2;
    public static final int LEFT_EXTENT = 2;
    public static final int RIGHT_EXTENT = 4;
    private boolean[][] data = null;
    private Logger logger = null;

    public ReaderTranslatedSource(RasterSource source, Point2D[] master, Point2D[] guide, int threshold) {
        super(source, master, guide);
        this.setThreshold(threshold);
    }

    public ReaderTranslatedSource(RasterSource source, Point2D[] master, Point2D[] guide, int threshold, Logger logger) {
        this(source, master, guide, threshold);
        this.logger = logger;
    }

    public ReaderTranslatedSource(Raster raster, Point2D[] master, Point2D[] guide, int threshold) {
        super(raster, master, guide);
        this.setThreshold(threshold);
    }

    public ReaderTranslatedSource(Raster raster, Point2D[] master, Point2D[] guide, int threshold, Logger logger) {
        this(raster, master, guide, threshold);
        this.logger = logger;
    }

    public Raster cropRaster(Rectangle rect) {
        return this.cropRaster(rect.x, rect.y, rect.width, rect.height);
    }

    public Raster cropRaster(Rectangle rect, double scale) {
        return this.cropRaster(rect.x, rect.y, rect.width, rect.height, scale);
    }

    public Raster cropRaster(int x, int y, int w, int h, double scale) {
        WritableRaster ret = this.createCompatibleWritableRaster((int)((double)w * scale), (int)((double)h * scale));
        Point2D.Double p = new Point2D.Double();
        int[] color = new int[4];
        int j = 0;
        while ((double)j < (double)h * scale) {
            int i = 0;
            while ((double)i < (double)w * scale) {
                int argb = this.getRGBColor((double)x + (double)i / scale, (double)y + (double)j / scale, (Point2D)p);
                color[0] = argb >> 24 & 0xFF;
                color[1] = argb >> 16 & 0xFF;
                color[2] = argb >> 8 & 0xFF;
                color[3] = argb & 0xFF;
                if (this.getNumBands() == 1) {
                    color[0] = 255 - color[0];
                    color[1] = 255 - color[1];
                    color[2] = 255 - color[2];
                    color[3] = 255 - color[3];
                    ret.setPixel(i, j, color);
                } else {
                    ret.setPixel(i, j, color);
                }
                ++i;
            }
            ++j;
        }
        return ret;
    }

    public Raster cropRaster(int x, int y, int w, int h) {
        WritableRaster ret = this.createCompatibleWritableRaster(w, h);
        Point2D.Double p = new Point2D.Double();
        int[] color = new int[4];
        int j = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                int argb = this.getRGBColor(x + i, y + j, (Point2D)p);
                color[0] = argb >> 24 & 0xFF;
                color[1] = argb >> 16 & 0xFF;
                color[2] = argb >> 8 & 0xFF;
                color[3] = argb & 0xFF;
                if (this.getNumBands() == 1) {
                    color[0] = 255 - color[0];
                    color[1] = 255 - color[1];
                    color[2] = 255 - color[2];
                    color[3] = 255 - color[3];
                    ret.setPixel(i, j, color);
                } else {
                    ret.setPixel(i, j, color);
                }
                ++i;
            }
            ++j;
        }
        return ret;
    }

    double getDensity(Rectangle rect) {
        int w = rect.width + 2 + 4;
        int h = rect.height + -3 + -2;
        Point2D.Double p = new Point2D.Double();
        if (this.data == null) {
            this.data = new boolean[h][w];
        }
        char[] message = null;
        int y = 0;
        while (y < h) {
            message = new char[w];
            int x = 0;
            while (x < w) {
                boolean bl = this.isBlack(this.getRGBColor(rect.x - 2 + x, rect.y - -3 + y));
                this.data[y][x] = bl;
                message[x] = bl ? 111 : 45;
                ++x;
            }
            ++y;
        }
        int density = 0;
        int y2 = 1;
        while (y2 < h - 1) {
            message = new char[w - 1];
            message[0] = 32;
            int x = 1;
            while (x < w - 1) {
                if (this.getPixelThroughFilter(x, y2)) {
                    message[x] = 42;
                    ++density;
                } else {
                    message[x] = 45;
                }
                ++x;
            }
            ++y2;
        }
        return 1.0 * (double)density / (double)((w - 2) * (h - 2));
    }

    final boolean getPixelThroughFilter(int x, int y) {
        boolean target = false;
        int numBlackPixel = 0;
        int j = -1;
        while (j <= 1) {
            int i = -1;
            while (i <= 1) {
                boolean color = this.data[y + j][x + i];
                if (i == 0 && j == 0) {
                    target = color;
                } else {
                    numBlackPixel += color ? 1 : 0;
                }
                ++i;
            }
            ++j;
        }
        if (target) {
            if (numBlackPixel <= 2) {
                return false;
            }
        } else if (8 <= numBlackPixel) {
            return true;
        }
        return target;
    }

    void translatePointArray(Point2D[] markRectCorners, Rectangle rect) {
        markRectCorners[0] = this.getPoint(rect.x, rect.y, 1.0, markRectCorners[0]);
        markRectCorners[1] = this.getPoint(rect.x + rect.width, rect.y, 1.0, markRectCorners[1]);
        markRectCorners[2] = this.getPoint(rect.x, rect.y + rect.height, 1.0, markRectCorners[2]);
        markRectCorners[3] = this.getPoint(rect.x + rect.width, rect.y + rect.height, 1.0, markRectCorners[3]);
    }
}

