/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import net.sf.sqs_xml.editor.base.swing.AbstractNodeTreePane;

public class NodeTreeSelectionModel
extends DefaultTreeSelectionModel {
    public static final int NORMAL_MODE = 0;
    public static final int XOR_MODE = 1;
    AbstractNodeTreePane tree;

    public NodeTreeSelectionModel(AbstractNodeTreePane tree) {
        this.setSelectionMode(4);
        this.tree = tree;
    }

    Set getEditablePathSet(int row1, int row2) {
        LinkedHashSet<TreePath> set = new LinkedHashSet<TreePath>();
        int min = Math.min(row1, row2);
        int max = Math.max(row1, row2);
        TreePath prevEditablePath = null;
        int i = min;
        while (i <= max) {
            TreePath path = this.tree.getEditablePath(this.tree.getPathForRow(i));
            TreePath editablePath = this.tree.getEditablePath(path);
            if (prevEditablePath == null || !prevEditablePath.isDescendant(editablePath)) {
                set.add(editablePath);
            }
            prevEditablePath = editablePath;
            ++i;
        }
        return set;
    }

    void xORSelection(int row1, int row2) {
        Set set = this.getEditablePathSet(row1, row2);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TreePath path = (TreePath)it.next();
            if (this.isPathSelected(path)) {
                this.removeSelectionPath(path);
                continue;
            }
            this.addSelectionPath(path);
        }
        set.clear();
    }

    public void selectNodeGroup(int row1, int row2) {
        int min = Math.min(row1, row2);
        int max = Math.max(row1, row2);
        int i = min;
        while (i <= max) {
            this.selectNodeGroup(i);
            ++i;
        }
    }

    public void removeHierachicalSelected() {
        int i = 0;
        while (i < this.getSelectionCount()) {
            TreePath path = this.getSelectionPaths()[i];
            if (this.isHierachicalSelected(path)) {
                this.removeSelectionPath(path);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isHierachicalSelected(TreePath path) {
        p = path;
        if (p != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (!this.isPathSelected(p)) continue;
            return true;
lbl6:
            // 2 sources

            ** while ((p = p.getParentPath()) != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    public void selectNodeGroup(int rowClicked) {
        TreePath clickedPath = this.tree.getPathForRow(rowClicked);
        TreePath clickedTargetPath = this.tree.getEditablePath(clickedPath);
        if (clickedTargetPath == null) {
            return;
        }
        boolean isSelectedByAncestor = this.removeAncestorSelectedPath(clickedTargetPath);
        if (!isSelectedByAncestor) {
            this.tree.addSelectionPath(clickedTargetPath);
        }
    }

    private boolean removeAncestorSelectedPath(TreePath clickedTargetPath) {
        int[] rows = this.getSelectionRows();
        boolean isSelectedByAncestor = false;
        if (rows != null) {
            int i = 0;
            while (i < rows.length) {
                TreePath aSelectedPath = this.tree.getPathForRow(rows[i]);
                if (aSelectedPath.isDescendant(clickedTargetPath)) {
                    isSelectedByAncestor = true;
                } else if (clickedTargetPath.isDescendant(aSelectedPath)) {
                    this.tree.removeSelectionPath(aSelectedPath);
                }
                ++i;
            }
        }
        return isSelectedByAncestor;
    }
}

