/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.source;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.source.SourceException;
import net.sf.sqs_xml.util.FileUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SQSSource
extends DOMTreeSource {
    public SQSSource() throws SourceException {
    }

    public SQSSource(File file) throws SourceException {
        super(file);
    }

    public SQSSource(URL url, boolean readonly, String title) throws SourceException {
        super(url, readonly, title);
    }

    public Document createDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        FileUtil.keywordSubstitution(file, "http://www.w3.org/TR/xhtml2", "http://www.w3.org/2002/06/xhtml2", "UTF-8");
        return super.createDocument(file);
    }

    public Document createDocument(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        in = this.adhocFixXHTML2Namespace(in);
        return super.createDocument(in);
    }

    private InputStream adhocFixXHTML2Namespace(InputStream in) throws IOException, FileNotFoundException {
        File tmp = File.createTempFile("sqs-temp-", ".sqs");
        tmp.deleteOnExit();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
        FileUtil.keywordSubstitution(in, out, "http://www.w3.org/TR/xhtml2", "http://www.w3.org/2002/06/xhtml2", "UTF-8");
        ((OutputStream)out).close();
        in.close();
        in = new BufferedInputStream(new FileInputStream(tmp));
        return in;
    }
}

