/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import net.sf.sqs_xml.image.RasterSource;
import net.sf.sqs_xml.reader.logic.ReaderImageProcessor;
import net.sf.sqs_xml.reader.logic.ReaderProcessView;
import net.sf.sqs_xml.reader.logic.ThreadSuspendingException;
import net.sf.sqs_xml.reader.model.ImageFilesImagefile;
import net.sf.sqs_xml.reader.model.ScanFrame;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.StringUtil;

class FileFunctions {
    FileFunctions() {
    }

    static void confirmRetryPageSaving(ReaderProcessView view, IOException ex, File file) throws ThreadSuspendingException {
        if (view.showFileSaveErrorDialog(ex, file) == 1) {
            throw new ThreadSuspendingException();
        }
    }

    public static String getRelativePath(File imagedir, File file) {
        return file.getAbsolutePath().substring(imagedir.getParentFile().getAbsolutePath().length() + 1);
    }

    private static String id2qname(String id) {
        StringBuffer ret = new StringBuffer();
        int p = 0;
        int i = 0;
        while (i < 3) {
            int begin = -1;
            int end = -1;
            begin = id.indexOf("[", p);
            if (begin >= 0) {
                end = id.indexOf("]", begin + 1);
            }
            if (end >= 0) {
                p = end + 1;
            }
            if (begin >= 0 && end > 0) {
                if (i > 0) {
                    ret.append("-");
                }
                ret.append(id.substring(begin + 1, end));
            }
            ++i;
        }
        return ret.toString();
    }

    static File createTextareaImageFile(File imagedir, String textareaImageDirPath, int sampleID, String id, String filename) {
        String qname = FileFunctions.id2qname(id);
        String subname = filename.substring(imagedir.getAbsolutePath().length() + 1);
        String path = FileUtil.getBasename(subname);
        String ext = FileUtil.getSuffix(subname);
        return new File(String.valueOf(textareaImageDirPath) + File.separator + StringUtil.replaceAll(path, File.separator, "~") + "~" + ext + "-" + sampleID + "-" + qname + ".png");
    }

    static BufferedImage createErrorImage(ImageFilesImagefile target, RasterSource source, Color color) throws IOException {
        BufferedImage image = RasterSource.createImage(source.getRaster(), true);
        ScanFrame scanFrame = target.getScanFrame();
        if (scanFrame != null) {
            FileFunctions.drawScanFrame(image, scanFrame, color);
        }
        return image;
    }

    static File createErrorImageFile(File imagedir, String errorImageDirPath, String errorType, int fileIndex, String filename) {
        String subname = filename.substring(imagedir.getAbsolutePath().length() + 1);
        String path = FileUtil.getBasename(subname);
        String ext = FileUtil.getSuffix(subname);
        return new File(String.valueOf(errorImageDirPath) + File.separator + StringUtil.replaceAll(path, File.separator, "~") + "~" + ext + "-" + (fileIndex + 1) + "-" + errorType + ".png");
    }

    static void saveErrorImage(final File imagedir, final String errorImageDirPath, final String errorType, final int fileIndex, final ImageFilesImagefile target, final RasterSource source, final Color color) throws IOException {
        new Thread(){

            public void run() {
                try {
                    File path = FileFunctions.createErrorImageFile(imagedir, errorImageDirPath, errorType, fileIndex, target.getFilename());
                    FileUtil.writeImageFile(path, FileFunctions.createErrorImage(target, source, color));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }

    static void drawScanFrame(BufferedImage image, ScanFrame scanFrame, Color color) {
        ReaderImageProcessor.drawScanFrameRect(image, color, scanFrame, image.getWidth(), image.getHeight());
    }

    static Timestamp getPrevMTime(String imageFilePath) {
        return null;
    }
}

