/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sf.sqs_xml.swing.SuffixBasedFileFilter;

public class SwingUtil {
    public static Color FORGROUND_COLOR = new Color(153, 153, 204);

    public static WindowAdapter createConfirmOnExitAdapter(final JFrame frame, final String title, final String message) {
        frame.setDefaultCloseOperation(0);
        return new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                int result = JOptionPane.showConfirmDialog(frame, message, title, 0);
                if (result == 0) {
                    System.exit(0);
                }
            }
        };
    }

    public static SuffixBasedFileFilter createSuffixBasedFileFilter(String suffix, String description) {
        return new SuffixBasedFileFilter(suffix, description);
    }

    public static Object newInstanceWithWaitPromptFrame(Factory factory, String title, String message) throws Exception {
        JProgressBar progressBar = SwingUtil.createProgressBar();
        JPanel panel = SwingUtil.createPanel(message, progressBar);
        JFrame frame = SwingUtil.createFrame(title, panel);
        Object instance = factory.create();
        SwingUtil.closeFrame(frame, progressBar);
        return instance;
    }

    private static JPanel createPanel(String message, JProgressBar progressBar) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(new JLabel(message));
        panel.add(progressBar);
        return panel;
    }

    private static JProgressBar createProgressBar() {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        progressBar.setIndeterminate(false);
        progressBar.setMaximum(100);
        progressBar.setValue(100);
        return progressBar;
    }

    private static void closeFrame(JFrame frame, JProgressBar progressBar) {
        frame.setVisible(false);
        frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    private static JFrame createFrame(String title, JPanel panel) {
        JFrame frame = new JFrame();
        frame.setCursor(Cursor.getPredefinedCursor(3));
        frame.setDefaultCloseOperation(3);
        frame.setTitle(title);
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public static abstract class Factory {
        public abstract Object create() throws Exception;
    }
}

