/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.translator.swing;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.xml.transform.TransformerException;
import net.sf.sqs_xml.editor.base.swing.SuffixBasedFileChooser;
import net.sf.sqs_xml.swing.FileChooserPanel;
import net.sf.sqs_xml.swing.IconTitledPane;
import net.sf.sqs_xml.swing.LoggerConsoleFrame;
import net.sf.sqs_xml.swing.SuffixBasedFileFilter;
import net.sf.sqs_xml.swing.SwingUtil;
import net.sf.sqs_xml.translator.logic.Translator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;
import net.sf.sqs_xml.util.FileUtil;

public abstract class FileTranslator
extends JFrame {
    protected Translator translator = null;
    protected FileChooserPanel inputFileChooserPanel;
    protected SuffixBasedFileChooser outputFileChooser;
    protected JPanel outputFilePanel;
    protected JButton fileSaveButton;

    public FileTranslator(Icon icon, String title, Translator translator, SuffixBasedFileChooser inputFileChooser, String inputFileLabel, SuffixBasedFileChooser outputFileChooser, String outputFileLabel) throws Exception {
        this.addWindowListener(SwingUtil.createConfirmOnExitAdapter(this, "Exit Confirmation", "\u7d42\u4e86\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b?"));
        this.translator = translator;
        this.setTitle(title);
        this.outputFileChooser = outputFileChooser;
        this.inputFileChooserPanel = new FileChooserPanel(this, "1: " + inputFileLabel, "\u5165\u529b: ", inputFileChooser){

            public void fireFileSelection(File file) {
                FileTranslator.this.save(file);
            }
        };
        this.fileSaveButton = this.createFileSaveButton();
        if (inputFileChooser.getSelectedFile() == null) {
            this.fileSaveButton.setEnabled(false);
        } else {
            this.fileSaveButton.setEnabled(true);
        }
        JPanel basePanel = this.createBasePanel(icon, title, this.inputFileChooserPanel, this.createOutputPanel(outputFileLabel, this.fileSaveButton));
        this.getContentPane().add(basePanel);
    }

    public void setSlectedFile(File file) {
        this.inputFileChooserPanel.setSelectedFile(file);
    }

    private JButton createFileSaveButton() {
        JButton fileSaveButton = new JButton("\u4fdd\u5b58");
        fileSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                String target = FileTranslator.this.inputFileChooserPanel.getAbsolutePath();
                if (target != null && !"".equals(target)) {
                    FileTranslator.this.save(new File(target));
                }
            }
        });
        return fileSaveButton;
    }

    private JPanel createOutputPanel(String outputFileLabel, JButton fileSaveButton) {
        JPanel outputPanel = new JPanel();
        outputPanel.setBorder(BorderFactory.createTitledBorder("2: " + outputFileLabel));
        outputPanel.setLayout(new BoxLayout(outputPanel, 0));
        outputPanel.add(Box.createHorizontalStrut(5));
        outputPanel.add(new JLabel("\u51fa\u529b: "));
        outputPanel.add(Box.createHorizontalStrut(5));
        outputPanel.add(fileSaveButton);
        outputPanel.add(Box.createHorizontalStrut(40));
        return outputPanel;
    }

    private JPanel createBasePanel(Icon icon, String title, JPanel inputPanel, JPanel outputPanel) {
        IconTitledPane basePanel = new IconTitledPane();
        basePanel.initialize(icon, title, new EtchedBorder());
        basePanel.setLayout(new BoxLayout(basePanel, 1));
        basePanel.add(inputPanel);
        basePanel.add(outputPanel);
        return basePanel;
    }

    public void setFinished(boolean isFinished) {
        if (isFinished) {
            this.inputFileChooserPanel.setEnabled(true);
            this.fileSaveButton.setEnabled(true);
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.inputFileChooserPanel.setEnabled(false);
            this.fileSaveButton.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void save(File sourceFile) {
        this.fileSaveButton.setEnabled(true);
        String defaultTargetFile = null;
        int result = 0;
        File selectedFile = null;
        if (this.outputFileChooser != null) {
            defaultTargetFile = FileUtil.getSuffixReplacedFilePath(sourceFile, this.outputFileChooser.getSuffix());
            if (defaultTargetFile != null) {
                this.outputFileChooser.setSelectedFile(new File(defaultTargetFile));
            } else if (sourceFile != null) {
                this.outputFileChooser.setSelectedFile(new File(String.valueOf(sourceFile.getAbsolutePath()) + this.outputFileChooser.getSuffix()));
            }
            result = this.outputFileChooser.showSaveDialog(this);
            selectedFile = this.outputFileChooser.getSelectedFile();
        }
        if (result == 0) {
            this.setFinished(false);
            this.translate(sourceFile, selectedFile);
        }
    }

    public void translate(File sourceFile, File targetFile) {
        new TranslatingTask(sourceFile, this.createResource(), targetFile).start();
    }

    public TranslatorResource createResource() {
        LoggerConsoleFrame logger = this.createLoggerConsoleFrame();
        return new TranslatorResource(logger);
    }

    public LoggerConsoleFrame createLoggerConsoleFrame() {
        final LoggerConsoleFrame logger = new LoggerConsoleFrame(String.valueOf(this.getTitle()) + " Log", "Cancel", "OK");
        logger.setFinished(false);
        logger.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                logger.setVisible(false);
                logger.setFinished(true);
                FileTranslator.this.setFinished(true);
            }
        });
        return logger;
    }

    public abstract SuffixBasedFileChooser createSuffixBasedFileChooser(SuffixBasedFileFilter var1);

    class TranslatingTask
    extends Thread {
        File sourceFile;
        File targetFile;
        TranslatorResource translatorResource;

        TranslatingTask(File sourceFile, TranslatorResource translatorResource, File targetFile) {
            this.sourceFile = sourceFile;
            this.targetFile = targetFile;
            this.translatorResource = translatorResource;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                logger = (LoggerConsoleFrame)this.translatorResource.getLogger();
                logger.setVisible(true);
                in = null;
                out = null;
                try {
                    try {
                        baseURI = null;
                        in = new BufferedInputStream(new FileInputStream(this.sourceFile));
                        out = new BufferedOutputStream(new FileOutputStream(this.targetFile));
                        FileTranslator.this.translator.translate(in, this.translatorResource, out, baseURI);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        logger.setError("", ex.getCause());
                    }
                    catch (TranslatorException ex) {
                        block12: {
                            if (logger == null) break block12;
                            if (ex.getCause() instanceof TransformerException) {
                                this.logTransformerError(logger, ex);
                            } else {
                                logger.setError("", ex.getCause());
                            }
                            ex.printStackTrace();
                            ** GOTO lbl-1000
                        }
                        ex.printStackTrace();
                    }
                }
                catch (Throwable var6_7) {
                    var5_8 = null;
                    try {
                        in.close();
                        out.close();
                    }
                    catch (Exception var7_10) {
                        // empty catch block
                    }
                    FileTranslator.this.setFinished(true);
                    logger.setFinished(true);
                    throw var6_7;
                }
lbl-1000:
                // 4 sources

                {
                    var5_9 = null;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 169->180)] { 
lbl42:
                // 1 sources

                in.close();
                out.close();
                break block13;
lbl45:
                // 1 sources

                catch (Exception var7_11) {
                    // empty catch block
                }
            }
            FileTranslator.this.setFinished(true);
            logger.setFinished(true);
        }

        private void logTransformerError(LoggerConsoleFrame logger, TranslatorException ex) {
            TransformerException e = (TransformerException)ex.getCause();
            if (e.getLocator() != null) {
                int lineNumber = e.getLocator().getLineNumber();
                int columnNumber = e.getLocator().getColumnNumber();
                logger.setError("File:" + this.sourceFile + "  Line:" + lineNumber + " Column:" + columnNumber, ex.getCause());
            } else {
                logger.setError("File:" + this.sourceFile, ex.getCause());
            }
        }
    }
}

