/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.CharDataChunk;
import org.apache.xerces.utils.StringPool;

public final class ChunkyCharArray
implements XMLEntityHandler.CharBuffer {
    private static final int INITIAL_CHUNK_SHIFT = 7;
    private static final int INITIAL_CHUNK_SIZE = 128;
    private StringPool fStringPool = null;
    private CharDataChunk fCurrentChunk = null;
    private char[] fCurrentData = null;
    private int fCurrentIndex = 0;
    private int fLength = 0;

    public final int length() {
        return this.fLength;
    }

    public final void append(char c) {
        try {
            this.fCurrentData[this.fCurrentIndex] = c;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.fCurrentIndex == 16384) {
                this.fCurrentChunk = CharDataChunk.createChunk(this.fStringPool, this.fCurrentChunk);
                this.fCurrentData = new char[128];
                this.fCurrentIndex = 0;
            } else {
                char[] cArray = new char[this.fCurrentIndex * 2];
                System.arraycopy(this.fCurrentData, 0, cArray, 0, this.fCurrentIndex);
                this.fCurrentData = cArray;
            }
            this.fCurrentChunk.setCharArray(this.fCurrentData);
            this.fCurrentData[this.fCurrentIndex] = c;
        }
        catch (NullPointerException nullPointerException) {
            this.fCurrentData = new char[128];
            this.fCurrentChunk.setCharArray(this.fCurrentData);
            this.fCurrentData[this.fCurrentIndex] = c;
        }
        ++this.fCurrentIndex;
        ++this.fLength;
    }

    public final void append(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.append(string.charAt(n2));
            ++n2;
        }
    }

    public final void append(char[] cArray, int n, int n2) {
        while (n2-- > 0) {
            this.append(cArray[n++]);
        }
    }

    public final void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
        this.fCurrentChunk.append(chunkyCharArray, n, n2);
    }

    public final int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(n, n2);
    }

    public final int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, 0);
    }

    public ChunkyCharArray(StringPool stringPool) {
        this.fStringPool = stringPool;
        this.fCurrentChunk = CharDataChunk.createChunk(stringPool, null);
    }
}

