/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.namespace;

public class QName {
    private final String uri;
    private final String localName;
    private final String prefix;

    public QName(String string) {
        this("", string, "");
    }

    public QName(String string, String string2) {
        this(string, string2, "");
    }

    public QName(String string, String string2, String string3) {
        if (string == null) {
            string = "";
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (string3 == null) {
            throw new IllegalArgumentException();
        }
        this.uri = string;
        this.localName = string2;
        this.prefix = string3;
    }

    public String getLocalPart() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.uri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int hashCode() {
        return this.localName.hashCode() ^ this.uri.hashCode();
    }

    public String toString() {
        if (this.uri.length() == 0) {
            return this.localName;
        }
        return '{' + this.uri + '}' + this.localName;
    }

    public boolean equals(Object object) {
        if (!(object instanceof QName)) {
            return false;
        }
        QName qName = (QName)object;
        return this.localName.equals(qName.localName) && this.uri.equals(qName.uri);
    }

    public static QName valueOf(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (string.charAt(0) == '{') {
            int n = string.lastIndexOf(125);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            return new QName(string.substring(1, n), string.substring(n + 1));
        }
        return new QName(string);
    }
}

