/*

 TreeNodePopupAdapter.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/10

 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;

import javax.swing.tree.TreePath;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TreeNodePopupAdapter implements ActionListener{
    private TreeNodePopupMenu menu;
    
    TreeNodePopupAdapter(TreeNodePopupMenu menu){
        this.menu = menu;        
    }
    
    public void actionPerformed(ActionEvent ev){
        String[] commandArgs = ev.getActionCommand().split("\\s");
        String command = commandArgs[0];
        int target = Integer.parseInt(commandArgs[1]);
        if(command.equals("d")){
            delete(target, true);
        }else if(command.equals("c")){
            delete(target, false);
        }else if(command.equals("b")){
            insert(target, true);
        }else if(command.equals("i")){
            insertWithin(target);
        }else if(command.equals("a")){
            insert(target, false);
        }else if(command.equals("S")){
            showAll(target);
        }else if(command.equals("H")){
            hideAll(target);
        }
        menu.getTreePane().updateUI();
    }
    
    private List getRecentCutNode(){
        return menu.getTreePane().mediator.menuBarMediator.getRecentCutNode();
    }
    
    private void setRecentCutNode(List list){
        menu.getTreePane().mediator.menuBarMediator.setRecentCutNode(list);
    }

    private void insert(int target, boolean isInsertBeforeMode) {
        if(isReadOnly()){
            return;
        }
        List recentCutNode = getRecentCutNode();
        if(recentCutNode == null || 0 == recentCutNode.size()){
            return;
        }
        NodeTreePane tree = menu.getTreePane();
        TreePath path = tree.getPathForRow(target);
        TreePath parentPath = path.getParentPath();
        Node currentNode = (Node)path.getLastPathComponent();
        Node parentNode = (Node)parentPath.getLastPathComponent();
        boolean appendMode = false;
        if(! isInsertBeforeMode){
            Node nextNode = currentNode.getNextSibling();
            if(nextNode == null){
                appendMode = true;
            }else{
                currentNode = nextNode; 
            }
        }
        insertNode(recentCutNode, tree, parentPath, currentNode, parentNode, appendMode);
        tree.mediator.tabbedPane.getCurrentEditingSource().setDirty(true);
        tree.mediator.tabbedPane.updateCurrentTitle();
        updateTree(tree);
    }

    private void insertNode(List recentCutNode, NodeTreePane tree, TreePath parentPath, Node currentNode, Node parentNode, boolean appendMode) {
        Document document = tree.mediator.tabbedPane.getCurrentEditingSource().getDocument();
        for(int i=0; i<recentCutNode.size(); i++){
            Node insertedNode = document.importNode((Node)recentCutNode.get(i), true);
            TreePath insertedPath = parentPath.pathByAddingChild(insertedNode);
            if(appendMode){
                menu.getTreePane().appendChildNode(parentNode, insertedNode);
            }else{
                menu.getTreePane().insertBefore(currentNode, parentNode, insertedNode);
            }
            tree.getSelectionModel().addSelectionPath(insertedPath);
        }
    }

    /**
     * @return
     */
    private boolean isReadOnly() {
        return menu.isReadOnly();
    }

    private void insertWithin(int target) {
        if(isReadOnly()){
            return;
        }
        List recentCutNode = getRecentCutNode();
        if(recentCutNode == null || 0 == recentCutNode.size()){
            return;
        }
        NodeTreePane tree = menu.getTreePane();
        TreePath currentPath = tree.getPathForRow(target);
        Node currentNode = (Node)currentPath.getLastPathComponent();

        for(int i=0; i<recentCutNode.size(); i++){
            Node insertedNode = ((Node)recentCutNode.get(i)).cloneNode(true);
            TreePath insertedPath = currentPath.pathByAddingChild(insertedNode);
            menu.getTreePane().appendChildNode(currentNode, insertedNode);
            tree.getSelectionModel().addSelectionPath(insertedPath);
        }
        tree.mediator.tabbedPane.getCurrentEditingSource().setDirty(true);
        tree.mediator.tabbedPane.updateCurrentTitle();
        updateTree(tree);
    }

    private void delete(int target, boolean isDeleteMode) {
        NodeTreePane tree = menu.getTreePane();
        int[] rows = tree.getSelectionModel().getSelectionRows();
        if(isNodeDeleteProihibited(isDeleteMode, tree, rows)){
            return;
        }
        List recentCutNode = resetRecentCutNode();
        deleteNode(isDeleteMode, tree, rows, recentCutNode);
        if(! isReadOnly() && isDeleteMode){
            updateTree(tree);
            tree.mediator.tabbedPane.getCurrentEditingSource().setDirty(true);
            tree.mediator.tabbedPane.updateCurrentTitle();
        }
    }

    private boolean isNodeDeleteProihibited(boolean isDeleteMode, NodeTreePane tree, int[] rows) {
        return rows.length == 0 || (isDeleteMode && 0 < rows.length && tree.mediator.getMenuBarMediator().avoidNodeDelete(rows.length));
    }

    private List resetRecentCutNode(){
        List recentCutNode = getRecentCutNode();
        if(recentCutNode == null){
            recentCutNode = new LinkedList();
            setRecentCutNode(recentCutNode);
        }else{
            recentCutNode.clear();
        }
        return recentCutNode;
    }
    
    private void deleteNode(boolean isDeleteMode, NodeTreePane tree, int[] rows, List recentCutNode) {
        for(int i=0; i<rows.length; i++){
            TreePath path = tree.getPathForRow(rows[i]);
            Node leaf = (Node)path.getLastPathComponent();
            Node parent = (Node)path.getParentPath().getLastPathComponent();
            recentCutNode.add(leaf);
            if(! isReadOnly() && isDeleteMode){
                parent.removeChild(leaf);
                tree.getSelectionModel().removeSelectionPath(path);
            }
        }
    }

    private void updateTree(NodeTreePane tree) {
        tree.setupEditorPane();
    }

    private void showAll(int target){
        NodeTreePane tree = menu.getTreePane();
        TreePath[] paths = tree.getSelectionPaths();
        for(int i = 0; i<paths.length; i++){
            //tree.expandPath(paths[i]);
            ((NodeTreePane)tree).expandDecendant((TreePath)paths[i]);
        }
    }
    
    private void hideAll(int target){
        boolean doCollapsed = false;
        NodeTreePane tree = menu.getTreePane();
        if(tree.isCollapsed(target)){
            return;
        }
        TreePath[] paths = tree.getSelectionPaths();
        for(int i = 0; i<paths.length; i++){
            TreePath branchPath = paths[i];
            if(tree.isCollapsed(branchPath)){
                continue;
            }
            NodeList branchObjectList = ((Node)branchPath.getLastPathComponent()).getChildNodes();
            for(int j = 0; j<branchObjectList.getLength(); j++){
                TreePath subBranchPath = branchPath.pathByAddingChild(branchObjectList.item(j));
                if(! tree.isCollapsed(subBranchPath)){
                    tree.collapsePath(subBranchPath);
                    doCollapsed = true;
                }
            }
        }
        if(! doCollapsed){
            tree.collapseRow(target);
        }
    }

}