/*

 FileFunctions.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/10/13

 */
package net.sf.sqs_xml.reader.logic;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import javax.swing.JOptionPane;
import net.sf.sqs_xml.image.RasterSource;
import net.sf.sqs_xml.reader.model.ImageFilesImagefile;
import net.sf.sqs_xml.reader.model.ScanFrame;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.StringUtil;

/**
 * @author hiroya
 *
 */
class FileFunctions{
    static void confirmRetryPageSaving(ReaderProcessView view, IOException ex, File file) throws ThreadSuspendingException {
        //confirmRetrySaving();
        if(view.showFileSaveErrorDialog(ex, file) == JOptionPane.NO_OPTION){
            throw new ThreadSuspendingException();
        }
    }

    public static String getRelativePath(File imagedir, File file) {
        return file.getAbsolutePath().substring(imagedir.getParentFile().getAbsolutePath().length()+1);
    }


    static private String id2qname(String id){
        StringBuffer ret = new StringBuffer();
        int p = 0;
        for(int i=0; i<3; i++){
            int begin = -1, end = -1;
            begin = id.indexOf("[", p);
            if(0 <= begin){
                end = id.indexOf("]", begin+1);
            }
            if(0 <= end){
                p = end+1;
            }
            if(0 <= begin && 0 < end){
                if(0 < i){
                    ret.append("-");
                }
                ret.append(id.substring(begin+1, end));
            }
        }
        return ret.toString();
    }

    static File createTextareaImageFile(File imagedir, String textareaImageDirPath, int sampleID, String id, String filename) {
        String qname = id2qname(id); 
        String subname = filename.substring(imagedir.getAbsolutePath().length()+1);
        String path = FileUtil.getBasename(subname);
        String ext = FileUtil.getSuffix(subname);
        return new File(textareaImageDirPath+File.separator+
                StringUtil.replaceAll(path, File.separator, "~")+
                "~"+ext+"-"+sampleID+"-"+qname+".png");
    }

    static BufferedImage createErrorImage(ImageFilesImagefile target, RasterSource source, Color color) throws IOException {
        BufferedImage image = RasterSource.createImage(source.getRaster(), true);
        ScanFrame scanFrame = target.getScanFrame();
        if(scanFrame != null){
            drawScanFrame(image, scanFrame, color);
        }
        return image;
    }

    static File createErrorImageFile(File imagedir, String errorImageDirPath, String errorType, int fileIndex, String filename) {
        String subname = filename.substring(imagedir.getAbsolutePath().length()+1);
        String path = FileUtil.getBasename(subname);
        String ext = FileUtil.getSuffix(subname);
        return new File(errorImageDirPath+File.separator+
                StringUtil.replaceAll(path, File.separator, "~")+
        			"~"+ext+"-"+(fileIndex+1)+"-"+errorType+".png");
    } 

    static void saveErrorImage(final File imagedir, final String errorImageDirPath,
            final String errorType, final int fileIndex, final ImageFilesImagefile target,
            final RasterSource source, final Color color) throws IOException {
        new Thread(){
            public void run(){
                try{
                    File path = createErrorImageFile(imagedir, errorImageDirPath, errorType, fileIndex, target.getFilename());
                    FileUtil.writeImageFile(path, createErrorImage(target, source, color));
                }catch(IOException ignore){}
            }
       }.start();
    }
    
    static void drawScanFrame(BufferedImage image, ScanFrame scanFrame, Color color) {
        ReaderImageProcessor.drawScanFrameRect(image, color, scanFrame, image.getWidth(), image.getHeight());
    }

    static Timestamp getPrevMTime(String imageFilePath) {
        /*
        if(prevImageFilesContext != null){
            ImageFiles imageFiles = prevReadData.getImageFiles();
            return imageFiles.getImageFilesImagefileByFilename(imageFile.getAbsolutePath()).getMtime();
        }else{
            return null;
        }
        */
        return null;
    }

}
