/*

 ReaderResultBuilder.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/11/01

 */
package net.sf.sqs_xml.reader.logic;


import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.xml.transform.TransformerException;

import net.sf.sqs_xml.httpd.MarkReaderHttpd;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.StringUtil;
import net.sf.sqs_xml.xmlns.SQSNamespaces;

/**
 * @author hiroya
 *
 */
public class ReaderResultBuilder {

    public static final int ALL_MODE = 0;
    public static final int TEXTAREA_MODE = 1;
    public static final int MARK_MODE = 2;
    protected Object[] matrix = null;
    protected List rowFileList = new LinkedList();

    private Map areaImageMap = new HashMap();
    Map cellIDToAreaFileMap = new HashMap();
    
    protected QuestionnaireSchema schema;
    private List currentRowFileList;
    
    public ReaderResultBuilder(){
    }
    
    public void setQuestionnaireSchema(QuestionnaireSchema schema){
        this.schema = schema;        
    }
    
    public void setRowSize(int size){
        this.matrix = new Object[size];
    }
   
    public void addRowFileList(List rowFileList){
        this.rowFileList.add(rowFileList);
        currentRowFileList = rowFileList;
    }

    public void addRowFile(File rowFile){
        this.currentRowFileList.add(rowFile);
    }
    
    public void setMatrix(int index, Object[] line){
        this.matrix[index] = line;
    }

    public List getColumnNames(){
        return this.schema.columnNames;
    }
    
    public int getPage(String id){
        try{
            return schema.getPage(id);
        }catch(TransformerException ex){
            return -1;
        }
    }
    
    class CellID{
        int rowId;
        String id;
        CellID(int rowId, String id){
            this.rowId = rowId;
            this.id = id;
        }
        public boolean equals(Object o){
            if(o == null && !(o instanceof CellID)){
                return false;
            }else{
                CellID c = (CellID)o;
                return c.rowId == rowId && c.id.equals(id); 
            }
        }
        public int hashCode(){
            return rowId+id.hashCode();
        }
    }
    
    public void putAreaFile(int rowId, String id, File areaFile){
        cellIDToAreaFileMap.put(new CellID(rowId, id), areaFile);
    }
    
    public File getAreaFile(int rowId, String id){
        return (File)cellIDToAreaFileMap.get(new CellID(rowId, id));
    }

    public void addAreaImage(int rowIndex, String qid, File file){
        areaImageMap.put(rowIndex+"\t"+qid, file);
    }

    
    public void saveCSV(File tgtfile, String encoding) throws TransformerException, IOException {
        PrintWriter out = FileUtil.createPrintWriter(tgtfile, encoding);
         saveCSVHeader(out);
         saveCVSBody(out);
         out.close();
     }

    public void saveHTML(File tgtfile, String encoding, File imagedir, File resultdir, int mode) throws TransformerException, IOException {
        PrintWriter out = FileUtil.createPrintWriter(tgtfile, encoding);
        saveHTML(out, encoding, imagedir, resultdir, tgtfile, mode);
        out.close();
     }

    /**
     * @param out
     */
    private void saveCVSBody(PrintWriter out) {
        for(int j=0; j < matrix.length; j++){
            out.print(j+1);
            out.print("\t");
            out.print(((List)rowFileList.get(j)).get(0));
            Object[] line = (Object[])matrix[j];
            saveCSVRow(out, j, line);
            out.println();
        }
    }

    private void saveCSVRow(PrintWriter out, int rowID, Object[] line) {
        for(int columnID=0; columnID < line.length; columnID++){
            out.print("\t");
            List columnNameList = getColumnNames();
            if(line[columnID] != null){
                String value = null;
                if(line[columnID] instanceof String){
                    value = (String)line[columnID];
                }else if(line[columnID] instanceof CellValueOption){
                    value = ((CellValueOption)line[columnID]).value;                        
                }
                String id = (String)columnNameList.get(columnID);
                File areaImageFile = (File)areaImageMap.get(rowID+"\t"+id);
                if(areaImageFile != null && areaImageFile.getName().endsWith("-MarkError.png")){
                    out.print("?");
                }else{
                    out.print(StringUtil.escape(value));
                }
            }
        }
    }

    /**
     * @param out
     */
    private void saveHTML(PrintWriter out, String encoding, File imagedir, File resultdir, File targetFile, int mode) throws TransformerException {
        try{
        out.println("<?xml version=\"1.0\" encoding=\""+encoding+"\"?>");
        //out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        out.println("<html xmlns=\""+SQSNamespaces.XHTML_URI+"\" xml:lang=\"ja\" lang=\"ja\" version=\"1.1\">");
        out.println("<head>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset="+encoding+"\" />");
        out.print("<title>");
        out.print(targetFile.getAbsolutePath());
        out.println("</title>");
        out.println("<style type=\"text/css\">table, th, td{border-style: solid; border-width: 1px; border-color: black;} tr.page{background-color:#bbf}tr.qid{background-color:#fbb} th.id{background-color:#bfb} img{border-width:0} body{background-color: #ddd; padding: 0.5em} textarea{background-color:#fff}</style></head>");
        out.println("<body>");
        out.println("<h1>"+targetFile.getAbsolutePath()+"</h1>");
        out.print("<table>");
        out.println("<thead>");
        out.print("<tr class=\"page\"><th rowspan=\"2\">sampleID</th>");
        out.print("<th rowspan=\"2\">file</th>");
        out.println();
        saveHTMLTableHeader1(out, imagedir, mode);
        out.print("</tr>");
        out.print("<tr class=\"qid\">");
        saveHTMLTableHeader2(out, mode);
        out.print("</tr>");
        out.println("</thead><tbody>");
        saveHTMLRows(out, imagedir, mode);
        out.print("</tbody>");
        out.println("</table>");
        out.println("</body></html>");
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }

    private void saveHTMLRows(PrintWriter out, File imagedir, int mode) {
        for(int rowID=0; rowID < matrix.length; rowID++){
            out.print("<tr>");
            out.print("<th class=\"id\">");
            out.print(rowID+1);
            out.print("</th>");
            out.print("<th class=\"id\"><ol>");
            List rowFiles = (List)rowFileList.get(rowID);
            for(int i = 0; i < rowFiles.size(); i++){
                File file = ((File)rowFiles.get(i));
                out.print("<li><a href=\"../"+FileFunctions.getRelativePath(imagedir, file)+"\">");
                out.print(file.getName());
                out.print("</a></li>");
            }
            out.print("</ol></th>");
            saveHTMLRowColumns(out, imagedir, mode, rowID);
            out.print("</tr>");
            out.println();
        }
    }

    private void saveHTMLTableHeader1(PrintWriter out, File imagedir, int mode) throws TransformerException {
        int page, prevPage = -1;
        int colspan = 0;
        for(int columnID = 0; columnID < getColumnNames().size(); columnID++){
            String id = (String)getColumnNames().get(columnID);          
            if((mode == TEXTAREA_MODE) && getAreaFile(0, id) == null){
                continue;
            }
            String columnName = (String)getColumnNames().get(columnID);
            page = getPage(columnName);
            //if((prevPage != -1 && page != prevPage) || columnID == getColumnNames().size() - 1){
                //out.print("<th colspan=\""+colspan+"\">");
            out.print("<th colspan=\"1\">");
            File file = (File)((List)rowFileList.get(0)).get(page-1);
            out.print("<a href=\"../"+FileFunctions.getRelativePath(imagedir, file)+"\">P."+page+"</a>");//tabindex=\""+columnID+"\" 
            out.println("</th>");
            //colspan = 0;
            //}
            //prevPage = page;
        }
    }

    private void saveHTMLTableHeader2(PrintWriter out, int mode) throws TransformerException {
        for(int columnID = 0; columnID < getColumnNames().size(); columnID++){
            String id = (String)getColumnNames().get(columnID);          
            if((mode == TEXTAREA_MODE) && getAreaFile(0, id) == null){
                continue;
            }
            String columnName = (String)getColumnNames().get(columnID);
            out.print("<th>");//<a href=\"\" tabindex=\""+columnID+"\">");// title=\"Page"+getPage(id)+"\"
            out.print(StringUtil.replaceAll(columnName, "/", "/<br/>"));
            out.println("</th>");
            //out.println("</a></th>");
        }
    }

    private void saveHTMLRowColumns(PrintWriter out, File imagedir, int mode, int rowID) {
        Object[] line = (Object[])matrix[rowID];
        for(int columnID = 0; columnID < line.length; columnID++){
            String id = (String)getColumnNames().get(columnID);
            File imagefile = getAreaFile(rowID, id);
            
            if((mode == TEXTAREA_MODE) && imagefile == null){
                continue;
            }
            
            File areaImageFile = (File)areaImageMap.get(rowID+"\t"+id);
            if(areaImageFile != null && areaImageFile.getName().endsWith("-MarkError.png")){
                out.print("<td style=\"background-color: #faf;\">");
                out.print("<a href=\"ERROR/"+areaImageFile.getName()+"\">?</a>");
                out.print("</td>");
                continue;
            }
    
            out.print("<td>");
            
            String value = null;            
            if(line[columnID] != null){
                if(line[columnID] instanceof String){
                    value = (String)line[columnID];
                }else if(line[columnID] instanceof CellValueOption){
                    value = ((CellValueOption)line[columnID]).value;
                }else{
                    value = line[columnID].getClass().getName();
                }
            }
            
            if((mode == TEXTAREA_MODE || mode == ALL_MODE) && imagefile != null){
                out.print("<a href=\"../"+FileFunctions.getRelativePath(imagedir, areaImageFile)+"\" title=\""+(rowID+1)+"-"+id+"\" tabindex=\""+columnID+"\">");
                out.print("<img src=\"TEXTAREA/"+imagefile.getName()+"\" alt=\""+(rowID+1)+"-"+id+"\"/>");
                out.print("</a>");
            }
                
                if(value != null){
                    out.print(StringUtil.escapeHTML(value));
                }else{
                    out.print(" ");
                }

            out.print("</td>");
        }
    }

    /**
     * @param out
     * @param columnNames
     */
    private void saveCSVHeader(PrintWriter out) throws TransformerException {
        List columnNames = getColumnNames();
        out.print("sampleID");
        out.print("\t");
        out.print("file");
        for(int i=0; i < columnNames.size(); i++){
            out.print("\t");
            String id = (String)columnNames.get(i);
            out.print(id);
        }
        out.println();
    }
}
