/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package net.sf.sqs_xml.reader.model;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>FormElementsMarkarea</b> is generated from reader.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="markarea" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader">
 *                           <attribute name="ref" java:mapKey="true"><data type="string"/></attribute>
 *                             <ref name="MarkDensity"/>
 *                         </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="markarea" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader"&gt;
 *                           &lt;attribute name="ref" java:mapKey="true"&gt;&lt;data type="string"/&gt;&lt;/attribute&gt;
 *                             &lt;ref name="MarkDensity"/&gt;
 *                         &lt;/element&gt;</pre>
 *
 * @version reader.rng (Fri Aug 06 03:48:33 GMT+09:00 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class FormElementsMarkarea implements java.io.Serializable, Cloneable, IRNSContainer, IRNode, IFormElementsChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
    private String ref_;
    private double markDensity_;
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>FormElementsMarkarea</code>.
     *
     */
    public FormElementsMarkarea() {
        ref_ = "";
    }

    /**
     * Creates a <code>FormElementsMarkarea</code>.
     *
     * @param source
     */
    public FormElementsMarkarea(FormElementsMarkarea source) {
        setup(source);
    }

    /**
     * Creates a <code>FormElementsMarkarea</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FormElementsMarkarea(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>FormElementsMarkarea</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public FormElementsMarkarea(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>FormElementsMarkarea</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public FormElementsMarkarea(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>FormElementsMarkarea</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FormElementsMarkarea(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>FormElementsMarkarea</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FormElementsMarkarea(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>FormElementsMarkarea</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FormElementsMarkarea(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>FormElementsMarkarea</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FormElementsMarkarea(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>FormElementsMarkarea</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FormElementsMarkarea(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>FormElementsMarkarea</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FormElementsMarkarea(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>FormElementsMarkarea</code> by the FormElementsMarkarea <code>source</code>.
     *
     * @param source
     */
    public void setup(FormElementsMarkarea source) {
        int size;
        ref_ = source.ref_;
        markDensity_ = source.markDensity_;
    }

    /**
     * Initializes the <code>FormElementsMarkarea</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>FormElementsMarkarea</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>FormElementsMarkarea</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        ref_ = URelaxer.getAttributePropertyAsString(element, "ref");
        markDensity_ = URelaxer.getElementPropertyAsDouble(stack.popElement());
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new FormElementsMarkarea((FormElementsMarkarea)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "markarea");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.ref_ != null) {
            URelaxer.setAttributePropertyByString(element, "ref", this.ref_);
        }
        URelaxer2.setElementPropertyByDouble(element, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "markDensity", this.markDensity_, rNSContext_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>FormElementsMarkarea</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>FormElementsMarkarea</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>FormElementsMarkarea</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>FormElementsMarkarea</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>FormElementsMarkarea</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>FormElementsMarkarea</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>ref</b>.
     *
     * @return String
     */
    public String getRef() {
        return (ref_);
    }

    /**
     * Sets the String property <b>ref</b>.
     *
     * @param ref
     */
    public void setRef(String ref) {
        this.ref_ = ref;
    }

    /**
     * Gets the double property <b>markDensity</b>.
     *
     * @return double
     */
    public double getMarkDensity() {
        return (markDensity_);
    }

    /**
     * Sets the double property <b>markDensity</b>.
     *
     * @param markDensity
     */
    public void setMarkDensity(double markDensity) {
        this.markDensity_ = markDensity;
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.append("<");
        URelaxer.makeQName(prefix, "markarea", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (ref_ != null) {
            buffer.append(" ");
            buffer.append("ref");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getRef())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("<");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.append(">");
        buffer.append(URelaxer.getString(getMarkDensity()));
        buffer.append("</");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.append(">");
        buffer.append("</");
        URelaxer.makeQName(prefix, "markarea", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.write("<");
        URelaxer.makeQName(prefix, "markarea", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (ref_ != null) {
            buffer.write(" ");
            buffer.write("ref");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getRef())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("<");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.write(">");
        buffer.write(URelaxer.getString(getMarkDensity()));
        buffer.write("</");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.write(">");
        buffer.write("</");
        URelaxer.makeQName(prefix, "markarea", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.print("<");
        URelaxer.makeQName(prefix, "markarea", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (ref_ != null) {
            buffer.print(" ");
            buffer.print("ref");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getRef())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("<");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.print(">");
        buffer.print(URelaxer.getString(getMarkDensity()));
        buffer.print("</");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.print(">");
        buffer.print("</");
        URelaxer.makeQName(prefix, "markarea", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getRefAsString() {
        return (URelaxer.getString(getRef()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMarkDensityAsString() {
        return (URelaxer.getString(getMarkDensity()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setRefByString(String string) {
        setRef(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMarkDensityByString(String string) {
        setMarkDensity(Double.parseDouble(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>FormElementsMarkarea</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "markarea")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "ref")) {
            return (false);
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer2.isTargetElement(child, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "markDensity")) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FormElementsMarkarea</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FormElementsMarkarea</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
