package org.kohsuke.rngom.dt.builtin;

import java.util.HashSet;
import java.util.Set;

import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;

import org.kohsuke.rngom.xml.util.WellKnownNamespaces;

public class BuiltinDatatypeLibrary implements DatatypeLibrary {
    private final DatatypeLibraryFactory factory;
    private DatatypeLibrary xsdDatatypeLibrary = null;

    public final static String [] XSD_DATATYPE_NAMES = {"string","boolean",
            "float","double","decimal",
            "dateTime","duration","hexBinary","base64Binary",
            "anyURI","ID","IDREF","ENTITY","NOTATION",
            "normalizedString","token","language",
            "IDREFS","ENTITIES","NMTOKEN","NMTOKENS","Name","QName","NCName",
            "integer","nonNegativeInteger","positiveInteger","nonPositiveInteger","negativeInteger",
            "byte","int","long","short","unsignedByte","unsignedInt","unsignedLong","unsignedShort",
            "date","time","gYearMonth","gYear","gMonthDay","gDay","gMonth"};
    private static Set xsdDatatypeSet = new HashSet();
    static{
        for(int i=0; i < XSD_DATATYPE_NAMES.length; i++){
            xsdDatatypeSet.add(XSD_DATATYPE_NAMES[i]);
        }
    }
    
    public static boolean isXsdDatatype(String type){
        return xsdDatatypeSet.contains(type);
    }
    
    BuiltinDatatypeLibrary(DatatypeLibraryFactory factory) {
        this.factory = factory;
    }

    
    public DatatypeBuilder createDatatypeBuilder(String type)
        throws DatatypeException {
        xsdDatatypeLibrary =
            factory.createDatatypeLibrary(
                WellKnownNamespaces.XML_SCHEMA_DATATYPES);
        if (xsdDatatypeLibrary == null)
            throw new DatatypeException();
        if (isXsdDatatype(type)) {
            return new BuiltinDatatypeBuilder(
                    xsdDatatypeLibrary.createDatatype(type));
        }
        throw new DatatypeException();
    }
    public Datatype createDatatype(String type) throws DatatypeException {
        return createDatatypeBuilder(type).createDatatype();
    }
}
