/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.fonts;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.fonts.type1.PFBParser;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFT1Stream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.render.pdf.CodePointMapping;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.tools.IOUtil;

public class SingleByteFont
extends Font
implements FontDescriptor {
    public String fontName = null;
    public String encoding = "WinAnsiEncoding";
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    public int capHeight = 0;
    public int xHeight = 0;
    public int ascender = 0;
    public int descender = 0;
    public int[] fontBBox = new int[4];
    public URL embedFileName = null;
    public String embedResourceName = null;
    public PDFStream embeddedFont = null;
    public int firstChar = 0;
    public int lastChar = 255;
    public int flags = 4;
    public int stemV = 0;
    public int italicAngle = 0;
    public int missingWidth = 0;
    public Map kerning = new HashMap();
    public boolean useKerning = true;
    public int[] width = null;
    public byte subType = 0;

    public final boolean hasKerningInfo() {
        return this.useKerning & this.kerning.isEmpty();
    }

    public final Map getKerningInfo() {
        if (this.useKerning) {
            return this.kerning;
        }
        return new HashMap();
    }

    public byte getSubType() {
        return this.subType;
    }

    public int getAvgWidth() {
        return -1;
    }

    public int getMinWidth() {
        return -1;
    }

    public int getMaxWidth() {
        return -1;
    }

    public int getleading() {
        return -1;
    }

    public int getStemH() {
        return 0;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    public String getCharEncoding() {
        return this.encoding;
    }

    public boolean isEmbeddable() {
        return this.embedFileName != null || this.embedResourceName != null;
    }

    public PDFStream getFontFile(int i) {
        InputStream instream = null;
        if (this.embedFileName != null) {
            try {
                instream = this.embedFileName.openStream();
            }
            catch (Exception e) {
                MessageHandler.error("Failed to embed fontfile: " + this.embedFileName);
            }
        }
        if (instream == null && this.embedResourceName != null) {
            try {
                instream = new BufferedInputStream(this.getClass().getResourceAsStream(this.embedResourceName));
            }
            catch (Exception e) {
                MessageHandler.error("Failed to embed fontresource: " + this.embedResourceName);
            }
        }
        if (instream == null) {
            return null;
        }
        try {
            if (this.subType == 1) {
                PFBParser parser = new PFBParser();
                PFBData pfb = parser.parsePFB(instream);
                this.embeddedFont = new PDFT1Stream(i);
                ((PDFT1Stream)this.embeddedFont).setData(pfb);
            } else {
                byte[] file = IOUtil.toByteArray(instream, 128000);
                this.embeddedFont = new PDFTTFStream(i, file.length);
                ((PDFTTFStream)this.embeddedFont).setData(file, file.length);
            }
            this.embeddedFont.addFilter("flate");
            this.embeddedFont.addFilter("ascii-85");
            instream.close();
        }
        catch (Exception e) {
            MessageHandler.error("Failed to read font data for embedded font: " + e.getMessage());
        }
        return this.embeddedFont;
    }

    public String encoding() {
        return this.encoding;
    }

    public String fontName() {
        return this.fontName;
    }

    public int getAscender() {
        return this.ascender;
    }

    public int getDescender() {
        return this.descender;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public int getAscender(int size) {
        return size * this.ascender;
    }

    public int getCapHeight(int size) {
        return size * this.capHeight;
    }

    public int getDescender(int size) {
        return size * this.descender;
    }

    public int getXHeight(int size) {
        return size * this.xHeight;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getFontBBox() {
        return this.fontBBox;
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    public int getStemV() {
        return this.stemV;
    }

    public int getFirstChar() {
        return 0;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public int width(int i, int size) {
        return size * this.width[i];
    }

    public int[] getWidths(int size) {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length - 1);
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * size;
        }
        return arr;
    }

    public char mapChar(char c) {
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        return '#';
    }
}

