/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.swing.ModuleManager;
import net.sf.sqs_xml.editor.base.swing.NodeFunctions;
import net.sf.sqs_xml.editor.base.swing.NodeTreeSelectionModel;
import net.sf.sqs_xml.editor.base.swing.SourceEditorTreeCellRenderer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractNodeTreePane
extends JTree {
    DOMTreeSource source;
    JTree self;
    TreeModel model;
    NodeTreeSelectionModel selectionModel;
    JPopupMenu popup;
    ModuleManager editorResourceFactory = null;

    public AbstractNodeTreePane(DOMTreeSource source) {
        this.source = source;
        this.self = this;
        this.editorResourceFactory = this.createEditorResourceFactory();
        this.model = source.getTreeModel();
        this.setModel(this.model);
        this.setEditable(false);
        this.setDragEnabled(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setExpandsSelectedPaths(true);
        this.setToggleClickCount(2);
        this.setDragEnabled(false);
        this.selectionModel = new NodeTreeSelectionModel(this);
        this.setSelectionModel(this.selectionModel);
        this.setCellRenderer(new SourceEditorTreeCellRenderer(this.editorResourceFactory));
    }

    public abstract ModuleManager createEditorResourceFactory();

    public ModuleManager getEditorResourceFactory() {
        return this.editorResourceFactory;
    }

    TreePath getEditablePath(TreePath path) {
        if (path == null) {
            return null;
        }
        TreePath currentPath = path;
        while (true) {
            Node node = (Node)currentPath.getLastPathComponent();
            String uri = node.getNamespaceURI();
            String localName = node.getLocalName();
            if (this.editorResourceFactory.isEditable(localName, uri)) {
                if (node instanceof Document) {
                    return null;
                }
                return currentPath;
            }
            if (currentPath == null || currentPath.getParentPath() == null) {
                return null;
            }
            currentPath = currentPath.getParentPath();
        }
    }

    public synchronized void appendChildNode(Node parentNode, Node insertedNode) {
        block2: {
            try {
                parentNode.appendChild(insertedNode);
            }
            catch (DOMException ex) {
                if (ex.code != 4) break block2;
                parentNode.appendChild(NodeFunctions.createNode(this.source, insertedNode));
            }
        }
    }

    public synchronized void insertBefore(Node currentNode, Node parentNode, Node insertedNode) {
        block2: {
            try {
                parentNode.insertBefore(insertedNode, currentNode);
            }
            catch (DOMException ex) {
                if (ex.code != 4) break block2;
                parentNode.insertBefore(NodeFunctions.createNode(this.source, insertedNode), currentNode);
            }
        }
    }

    public Icon getIcon(String localName, String uri) {
        return this.getTreeCellRenderer().getIcon(localName, uri);
    }

    public SourceEditorTreeCellRenderer getTreeCellRenderer() {
        return (SourceEditorTreeCellRenderer)this.getCellRenderer();
    }

    public abstract void setupRenderer(SourceEditorTreeCellRenderer var1);

    public DOMTreeSource getSource() {
        return this.source;
    }

    public void expandDecendant(TreePath path) {
        this.expandDecendant(path.getLastPathComponent(), path);
    }

    public void expandDecendant(Object nodeObject) {
        this.expandDecendant(nodeObject, new TreePath(nodeObject));
    }

    void expandDecendant(Object nodeObject, TreePath path) {
        if (this.model.isLeaf(nodeObject)) {
            return;
        }
        this.expandPath(path);
        int i = 0;
        while (i < this.model.getChildCount(nodeObject)) {
            Object child = this.model.getChild(nodeObject, i);
            this.expandDecendant(child, path.pathByAddingChild(child));
            ++i;
        }
    }
}

