/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import net.sf.sqs_xml.editor.base.swing.NodeTreePane;
import net.sf.sqs_xml.editor.base.swing.TreeNodePopupAdapter;

class TreeNodePopupMenu
extends JPopupMenu {
    private final NodeTreePane treePane;
    private TreeNodePopupAdapter listener;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;

    TreeNodePopupMenu(NodeTreePane tree, int rowIndex) {
        this.treePane = tree;
        this.listener = new TreeNodePopupAdapter(this);
        JMenuItem showAllMenuItem = this.createPopupMenuItem("\u9078\u629e\u3057\u305f\u30ce\u30fc\u30c9\u306e\u300c\u679d\u3092\u8868\u793a\u300d", "S " + rowIndex);
        JMenuItem hideAllMenuItem = this.createPopupMenuItem("\u9078\u629e\u3057\u305f\u30ce\u30fc\u30c9\u306e\u300c\u679d\u3092\u96a0\u3059\u300d", "H " + rowIndex);
        this.add(showAllMenuItem);
        this.add(hideAllMenuItem);
        this.addSeparator();
        this.cutMenuItem = this.createPopupMenuItem("\u9078\u629e\u3057\u305f\u30ce\u30fc\u30c9\u3092\u300c\u30ab\u30c3\u30c8\u300d", "d " + rowIndex);
        this.copyMenuItem = this.createPopupMenuItem("\u9078\u629e\u3057\u305f\u30ce\u30fc\u30c9\u3092\u300c\u30b3\u30d4\u30fc\u300d", "c " + rowIndex);
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        if (this.isReadOnly()) {
            this.cutMenuItem.setEnabled(false);
        }
        this.add(this.cutMenuItem);
        this.add(this.copyMenuItem);
        List recentCutNodes = tree.mediator.menuBarMediator.getRecentCutNode();
        if (recentCutNodes != null && recentCutNodes.size() > 0) {
            this.addSeparator();
            JMenuItem insertUpperMenu = this.createPopupMenuItem("\u2191  \u30af\u30ea\u30c3\u30af\u3057\u305f\u30ce\u30fc\u30c9\u306e\u300c\u524d\u300d\u306b\u8cbc\u308a\u4ed8\u3051", "b " + rowIndex);
            JMenuItem insertWithinMenu = this.createPopupMenuItem("\u2192  \u30af\u30ea\u30c3\u30af\u3057\u305f\u30ce\u30fc\u30c9\u306e\u300c\u679d\u300d\u3068\u3057\u3066\u8cbc\u308a\u4ed8\u3051", "i " + rowIndex);
            JMenuItem insertLowerMenu = this.createPopupMenuItem("\u2193  \u30af\u30ea\u30c3\u30af\u3057\u305f\u30ce\u30fc\u30c9\u306e\u300c\u5f8c\u300d\u306b\u8cbc\u308a\u4ed8\u3051", "a " + rowIndex);
            insertLowerMenu.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            if (this.isReadOnly()) {
                insertUpperMenu.setEnabled(false);
                insertWithinMenu.setEnabled(false);
                insertLowerMenu.setEnabled(false);
            }
            this.add(insertUpperMenu);
            this.add(insertWithinMenu);
            this.add(insertLowerMenu);
            this.setPopupSize(300, 150);
        } else {
            this.setPopupSize(300, 100);
        }
    }

    boolean isReadOnly() {
        return this.getTreePane().mediator.getSourceEditorTabbedPane().getCurrentEditingSource().isReadOnly();
    }

    public NodeTreePane getTreePane() {
        return this.treePane;
    }

    private JMenuItem createPopupMenuItem(String label, String command) {
        JMenuItem item = new JMenuItem(label);
        item.setActionCommand(command);
        item.addActionListener(this.listener);
        return item;
    }

    public JMenuItem getCutMenuItem() {
        return this.cutMenuItem;
    }

    public JMenuItem getCopyMenuItem() {
        return this.copyMenuItem;
    }
}

