/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.sf.sqs_xml.swing.IconFactory;
import net.sf.sqs_xml.swing.LoggerConsoleFrame;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;

public class ProgressLoggerConsoleFrame
extends LoggerConsoleFrame {
    static Icon grayIcon = IconFactory.create("ball.gray.gif");
    static Icon blueIcon = IconFactory.create("ball.blue.gif");
    static Icon yellowIcon = IconFactory.create("ball.yellow.gif");
    static Icon redIcon = IconFactory.create("ball.red.gif");
    public static final String[] STEP_DESCRIPTION = new String[]{"PDF\u30d5\u30a1\u30a4\u30eb\u306e\u691c\u51fa\u30fbPDF\u3057\u304a\u308a\u306e\u89e3\u6790", "\u51e6\u7406\u5bfe\u8c61\u3068\u306a\u308b\u30b9\u30ad\u30e3\u30f3\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u306e\u691c\u51fa", "\u30b9\u30ad\u30e3\u30f3\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u306e\u66f4\u65b0\u65e5\u6642\u306e\u78ba\u8a8d", "\u30b9\u30ad\u30e3\u30f3\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u53d6\u308a\u4f4d\u7f6e\u306e\u8a8d\u8b58", "\u30de\u30fc\u30af\u6b04\u306e\u6fc3\u5ea6\u8aad\u307f\u53d6\u308a\u30fb\u81ea\u7531\u8a18\u8ff0\u6b04\u306e\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u5207\u308a\u51fa\u3057", "\u56de\u7b54\u8005\u306b\u3088\u3063\u3066\u9078\u629e\u3055\u308c\u305f\u30de\u30fc\u30af\u306e\u62bd\u51fa"};
    JPanel[] progressPanes;
    JPanel progressPane;
    JLabel[] data;
    int numPages;
    public static final int NOT_PROCESSED = 0;
    public static final int PROCESSING = 1;
    public static final int SUCCEED = 2;
    public static final int FAIL = 3;

    public ProgressLoggerConsoleFrame(String title, String cancelButtonLabel, String finishButtonLabel) {
        super(title, cancelButtonLabel, finishButtonLabel);
    }

    public Logger createLogger(String title) {
        return new ConsoleLogger();
    }

    public void setBorderTitle(String title) {
        this.progressPane.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new TitledBorder(new EtchedBorder(), "\u8aad\u307f\u53d6\u308a\u51e6\u7406\u306e\u9032\u6357\u72b6\u6cc1" + (title == null ? "" : " : " + title))));
    }

    public void setPDFFile(File file, int numPages, int numColumns) {
        this.numPages = numPages;
        this.data[0].setText(String.valueOf(file.getAbsolutePath()) + " (" + numPages + "\u30da\u30fc\u30b8/\u8a2d\u554f\u30ab\u30e9\u30e0\u6570: " + numColumns + ")");
    }

    public void setPageNumberError(int numFiles, int numNumberOfPages) {
        String message = "\u7dcf\u30d5\u30a1\u30a4\u30eb\u6570: " + numFiles + " (" + numFiles / this.numPages + "\u30b5\u30f3\u30d7\u30eb?) \u2026 \u30da\u30fc\u30b8\u6570\u304c\u4e0d\u6b63\u3067\u3059:" + (this.numPages - numFiles % this.numPages) + "\u500b\u306e\u30d5\u30a1\u30a4\u30eb\u4e0d\u8db3?";
        this.data[1].setText(message);
    }

    public void setNumFiles(int numFiles) {
        this.data[1].setText("\u7dcf\u30d5\u30a1\u30a4\u30eb\u6570: " + numFiles + " (" + numFiles / this.numPages + "\u30b5\u30f3\u30d7\u30eb)");
    }

    public void setTargetFileCount(int numTargetFiles) {
        this.data[2].setText("\u51e6\u7406\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb\u6570: " + numTargetFiles);
    }

    public void setProcessedFile(int validFileIndex, int validFileTotal) {
        this.data[3].setText("\u51e6\u7406\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb: " + validFileIndex + "/" + validFileTotal);
    }

    public void setGuideError(int error, int validFileIndex, int validFileTotal) {
        this.data[3].setText("\u25a0\u306e\u5217\u3092\u6b63\u5e38\u306b\u8a8d\u8b58\u3067\u304d\u306a\u304b\u3063\u305f\u30d5\u30a1\u30a4\u30eb\u6570:" + error + " / \u51e6\u7406\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb: " + validFileIndex + "/" + validFileTotal);
    }

    public void setProcessedElements(int validFileIndex, int validFileTotal) {
        this.data[4].setText("\u51e6\u7406\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb: " + validFileIndex + "/" + validFileTotal);
    }

    public void setProcessedValues(int rowIndex, int numSamples) {
        this.data[5].setText("\u51e6\u7406\u5bfe\u8c61\u30b5\u30f3\u30d7\u30eb: " + rowIndex + "/" + numSamples);
    }

    public void initialize() {
        this.progressPane = new JPanel();
        this.setBorderTitle(null);
        this.progressPane.setLayout(new BoxLayout(this.progressPane, 1));
        this.progressPane.add(Box.createVerticalStrut(10));
        this.progressPanes = new JPanel[STEP_DESCRIPTION.length];
        this.data = new JLabel[STEP_DESCRIPTION.length];
        this.createComponents();
        this.progressPane.setPreferredSize(new Dimension(700, 450));
        this.progressPane.add(Box.createVerticalStrut(5));
        this.progressPane.add(this.getBase());
        this.getContentPane().add(this.progressPane);
        this.setSize(700, 450);
        this.setVisible(true);
    }

    private void createComponents() {
        int i = 0;
        while (i < STEP_DESCRIPTION.length) {
            this.createComponents(i);
            ++i;
        }
    }

    private void createComponents(int i) {
        JLabel[] stepItem = new JLabel[]{new JLabel(grayIcon), new JLabel(" Step " + (i + 1) + " :"), new JLabel(STEP_DESCRIPTION[i])};
        Box box1 = this.createStepItemComponents(stepItem);
        this.progressPanes[i] = new JPanel();
        this.progressPanes[i].setLayout(new BorderLayout());
        this.progressPanes[i].add(box1);
        this.data[i] = new JLabel("");
        this.data[i].setForeground(new Color(20, 20, 128));
        this.progressPane.add(this.progressPanes[i]);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(Box.createHorizontalStrut(20));
        box2.add(this.data[i]);
        box2.add(Box.createHorizontalStrut(20));
        this.progressPane.add(box2);
    }

    private Box createStepItemComponents(JLabel[] stepItem) {
        Box box1 = Box.createHorizontalBox();
        stepItem[0].setEnabled(false);
        stepItem[1].setEnabled(false);
        stepItem[2].setEnabled(false);
        box1.add(Box.createHorizontalStrut(30));
        box1.add(stepItem[0]);
        box1.add(stepItem[1]);
        box1.add(Box.createHorizontalStrut(15));
        box1.add(stepItem[2]);
        return box1;
    }

    public void setProgressState(int index, int mode) {
        JPanel progressPaneItem = this.progressPanes[index - 1];
        JComponent box = (JComponent)progressPaneItem.getComponent(0);
        if (mode == 2) {
            this.updateItem(box, index - 1, blueIcon);
        } else if (mode == 3) {
            this.updateItem(box, index, redIcon);
        } else if (mode == 1) {
            this.updateItem(box, index - 1, yellowIcon);
        }
    }

    private void updateItem(JComponent box, int index, Icon icon) {
        int i = 0;
        while (i < box.getComponentCount()) {
            JComponent part = (JComponent)box.getComponent(i);
            if (i == 1) {
                JLabel iconLabel = (JLabel)part;
                if (iconLabel.getIcon().equals(redIcon)) {
                    return;
                }
                iconLabel.setIcon(icon);
            }
            part.setEnabled(true);
            ++i;
        }
    }
}

