/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.modules.panel;

import javax.swing.JScrollPane;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import net.sf.sqs_xml.util.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SelectFormItemListModel {
    SourceEditorMediator mediator;
    DOMTreeSource source;
    Element elem;
    SelectFormItemListModel model;
    JScrollPane itemListFormScrollPane;

    public SelectFormItemListModel(SourceEditorMediator mediator, DOMTreeSource source, Element elem) {
        this.mediator = mediator;
        this.source = source;
        this.elem = elem;
    }

    public SelectFormItemListModel(SourceEditorMediator mediator, DOMTreeSource source, Element elem, int n) {
        this(mediator, source, elem);
        int i = 0;
        while (i < n) {
            Element element = this.createItemElement("", "", 1);
            ++i;
        }
    }

    public void renumber() {
        NodeList list = this.getItemNodeList();
        int i = 0;
        while (i < list.getLength()) {
            Element item = (Element)list.item(i);
            DOMUtil.setNodeValue(this.source.getDocument(), item, "xforms:value/text()", new Integer(i + 1).toString());
            ++i;
        }
    }

    public int size() {
        return this.getItemNodeList().getLength();
    }

    private Element createItemElement(String label, String value, int colspan) {
        Element labelElem = this.createLabelElement(label);
        Element valueElem = this.createValueElement(value);
        Element itemElem = this.createItemElement(colspan, labelElem, valueElem);
        return itemElem;
    }

    private Element createItemElement(int colspan, Element labelElem, Element valueElem) {
        Element itemElem = this.source.getDocument().createElementNS("http://www.w3.org/2002/xforms", "item");
        itemElem.setPrefix("xforms");
        itemElem.setAttributeNS("http://sqs.cmr.sfc.keio.ac.jp/2004/sqs", "colspan", new Integer(colspan).toString());
        itemElem.appendChild(labelElem);
        itemElem.appendChild(valueElem);
        return itemElem;
    }

    private Element createValueElement(String value) {
        Element valueElem = this.source.getDocument().createElementNS("http://www.w3.org/2002/xforms", "value");
        valueElem.setPrefix("xforms");
        valueElem.appendChild(this.source.getDocument().createTextNode(value));
        return valueElem;
    }

    private Element createLabelElement(String label) {
        Element labelElem = this.source.getDocument().createElementNS("http://www.w3.org/2002/xforms", "label");
        labelElem.setPrefix("xforms");
        labelElem.appendChild(this.source.getDocument().createTextNode(label));
        return labelElem;
    }

    public void remove(int index) {
        if (this.source.isReadOnly()) {
            return;
        }
        this.elem.removeChild(this.getItemNode(index));
        this.renumber();
    }

    public void add(String label, String value, int colspan) {
        if (this.source.isReadOnly()) {
            return;
        }
        Element itemElem = this.createItemElement(label, value, colspan);
        this.elem.appendChild(itemElem);
        this.renumber();
    }

    public void insert(int index, String label, String value, int colspan) {
        if (this.source.isReadOnly()) {
            return;
        }
        Element itemElem = this.createItemElement(label, value, colspan);
        this.elem.insertBefore(itemElem, this.getItemNode(index));
        this.renumber();
    }

    public boolean updateNodeValue(int index, String label, String value, int colspan) {
        if (this.source.isReadOnly()) {
            return false;
        }
        Document document = this.source.getDocument();
        Element item = this.getItemNode(index);
        String prevLabel = DOMUtil.stringValueOf(document, item, "xforms:label/text()");
        String prevValue = DOMUtil.stringValueOf(document, item, "xforms:value/text()");
        int prevColspan = 1;
        try {
            prevColspan = DOMUtil.intValueOf(document, item, "@sqs:colspan");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!label.equals(prevLabel) || !value.equals(prevValue) || colspan != prevColspan) {
            DOMUtil.setNodeValue(document, item, "xforms:label/text()", label);
            DOMUtil.setNodeValue(document, item, "xforms:value/text()", value);
            DOMUtil.setAttributeValue(document, item, ".", "http://sqs.cmr.sfc.keio.ac.jp/2004/sqs", "sqs", "colspan", new Integer(colspan).toString());
            return true;
        }
        return false;
    }

    public String getLabel(int index) {
        Element item = this.getItemNode(index);
        return DOMUtil.stringValueOf(this.source.getDocument(), item, "xforms:label/text()");
    }

    public String getValue(int index) {
        Element item = this.getItemNode(index);
        return DOMUtil.stringValueOf(this.source.getDocument(), item, "xforms:value/text()");
    }

    public int getColspan(int index) {
        Element item = this.getItemNode(index);
        try {
            return DOMUtil.intValueOf(this.source.getDocument(), item, "@sqs:colspan");
        }
        catch (Exception ignore) {
            return 1;
        }
    }

    public NodeList getItemNodeList() {
        return this.elem.getElementsByTagNameNS("http://www.w3.org/2002/xforms", "item");
    }

    public Element getItemNode(int index) {
        return (Element)this.getItemNodeList().item(index);
    }
}

