/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import net.sf.sqs_xml.reader.logic.ReaderIndexMapper;

public class ReaderRunningState {
    public static final int NOT_STARTED = 0;
    public static final int RUNNING = 1;
    public static final int SUSPENDING = 2;
    public static final int SUSPENDED = 3;
    public static final int FINISHED = 4;
    public static final int ABORTED = 5;
    private int state = 0;
    ReaderIndexMapper result;

    public ReaderRunningState(ReaderIndexMapper result) {
        this.result = result;
        result.reset();
    }

    public ReaderIndexMapper getState() {
        return this.result;
    }

    public boolean taskStopRequested() {
        return this.state == 2;
    }

    public void start() {
        if (this.state == 0) {
            this.state = 1;
        }
    }

    public void suspending() {
        if (this.state == 1) {
            this.state = 2;
        }
    }

    public void spspended() {
        if (this.state == 2) {
            this.state = 3;
        }
    }

    public void restart() {
        this.result.reset();
        if (this.state == 3) {
            this.state = 1;
        }
    }

    public void finished() {
        if (this.state == 1) {
            this.state = 4;
        }
    }

    public boolean isFinished() {
        return this.state == 4;
    }

    public void aborted() {
        if (this.state == 1) {
            this.state = 5;
        }
    }

    public synchronized void waitTaskStopped() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void notifyTaskStopped() {
        this.notifyAll();
    }
}

