/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.translator.logic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.sqs_xml.editor.sqs.swing.SQSSourceEditorMediator;
import net.sf.sqs_xml.httpd.SourceEditorHttpd;
import net.sf.sqs_xml.translator.logic.AbstractTranslator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Options;

public class SQStoPDFTranslator
extends AbstractTranslator {
    public static final String SQS2FO = AbstractTranslator.prop.getString("sqs2fo_xsl_file");
    static final String USERCONFIG_URL = String.valueOf(SQSSourceEditorMediator.BASEURI) + "/userconfig.xml";

    public static void main(String[] args) throws Exception {
        AbstractTranslator.main(args, "net.sf.sqs_xml.translator.logic.SQStoPDFTranslator <in.sqs> <out.pdf>", SQS2FO.split(" "), new SQStoPDFTranslator(), SourceEditorHttpd.getSingleton().getBase());
    }

    public void init() throws TranslatorException {
        super.init();
        System.setProperty("java.awt.headless", "true");
        try {
            new Options(new URL(USERCONFIG_URL).openStream());
        }
        catch (IOException ex) {
            throw new TranslatorException(ex);
        }
        catch (FOPException ex) {
            throw new TranslatorException((Exception)((Object)ex));
        }
    }

    public void translate(InputStream inputStream, TranslatorResource resource, OutputStream outputStream, String baseURI) throws TranslatorException {
        resource.setXsltFilenames(SQS2FO.split(" "));
        super.translate(inputStream, resource, outputStream, baseURI);
    }

    public void execute(InputStream inputStream, TranslatorResource resource, OutputStream outputStream, TransformerHandler starterHandler, TransformerHandler terminatorHandler) throws TranslatorException {
        Driver driver = new Driver();
        driver.setLogger(resource.getLogger());
        driver.setRenderer(1);
        driver.setOutputStream(outputStream);
        terminatorHandler.setResult(new SAXResult(driver.getContentHandler()));
    }

    public String[] getParameters(String filename) {
        if (filename.equals("embed-counter.xsl")) {
            return new String[]{"xhtml.h-attribute..sqs.prefix", "\u554f", "xhtml.h-attribute..sqs.suffix", ".", "xhtml.h-attribute..sqs.format", "1", "sqs.counter-attribute..sqs.prefix", "(", "sqs.counter-attribute..sqs.suffix", ")", "sqs.counter-attribute..sqs.format", "1"};
        }
        if (filename.equals("pxformsConvert1.xsl")) {
            return new String[]{"xforms.hint-attribute..sqs.prefix", "", "xforms.hint-attribute..sqs.suffix", "", "xforms.hint-attribute..sqs.display", "inline", "xforms.help-attribute..sqs.prefix", "(", "xforms.help-attribute..sqs.suffix", ")", "xforms.help-attribute..sqs.display", "inline", "xforms.alart-attribute..sqs.prefix", "*", "xforms.alart-attribute..sqs.suffix", "", "xforms.alart-attribute..sqs.display", "inline"};
        }
        if (filename.equals("outline.xsl")) {
            return new String[]{"bookmark-root-label", "\u8abf\u67fb\u7968\u306e\u69cb\u9020", "bookmark-section-label", "\u554f", "bookmark-question-label", "\u8a2d\u554f", "bookmark-itemset-label", "\u9078\u629e\u80a2"};
        }
        if (filename.equals("pxformsToFO.xsl")) {
            return new String[]{"example-blank-mark-label", " : \u7a7a\u767d\u30de\u30fc\u30af\u306e\u4f8b", "example-filled-mark-label", ": \u6b63\u3057\u3044\u5857\u308a\u6f70\u3057\u306e\u4f8b", "example-incomplete-mark-label", ": \u4e0d\u5341\u5206\u306a\u5857\u308a\u6f70\u3057\u306e\u4f8b", "characters-prohibit-line-break", "\u3002\uff0e\u3001\uff0c\u2019\u201d\uff09\uff5d\u300d\u300f\u3015\u3011\u3009\u300b\u3005\u301c\u2026\u30fc\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee)'"};
        }
        return null;
    }
}

