/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.util;

import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    public static Element getElement(Element node, String[][] args) {
        Element current = node;
        int i = 0;
        while (i < args.length) {
            String[] arg = args[i];
            String nsURI = arg[0];
            String localName = arg[1];
            current = (Element)DOMUtil.getElementList(current, nsURI, localName).item(0);
            ++i;
        }
        return current;
    }

    public static Element getElement(Element node, String nsURI, String localName) {
        return (Element)DOMUtil.getElementList(node, nsURI, localName).item(0);
    }

    public static NodeList getElementList(Element node, String nsURI, String localName) {
        return node.getElementsByTagNameNS(nsURI, localName);
    }

    public static String stringValueOf(Document document, Node node, String xpathString) {
        try {
            Node target = XPathAPI.selectSingleNode((Node)node, (String)xpathString, (Node)document);
            if (target == null) {
                return null;
            }
            if (target.getNodeType() == 3) {
                return target.getNodeValue();
            }
            if (target.getNodeType() == 2) {
                return ((Attr)target).getValue();
            }
            System.err.println("ERROR Type:unknown" + target.getNodeType());
            System.err.println("ERROR Node:" + node);
            System.err.println("ERROR XPath:" + xpathString);
            return null;
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Integer integerValueOf(Document document, Element node, String xpathString) {
        return new Integer(DOMUtil.intValueOf(document, node, xpathString));
    }

    public static Double doubleValueOf(Document document, Element node, String xpathString) {
        String value = DOMUtil.stringValueOf(document, node, xpathString);
        if (value == null) {
            throw new NullPointerException();
        }
        return new Double(Double.parseDouble(value));
    }

    public static int intValueOf(Document document, Element node, String xpathString) {
        return Integer.parseInt(DOMUtil.stringValueOf(document, node, xpathString));
    }

    public static void setNodeValue(Document document, Node node, String xpathString, String value) {
        try {
            Node target = XPathAPI.selectSingleNode((Node)node, (String)xpathString, (Node)document);
            if (target == null) {
                if (xpathString.endsWith("text()")) {
                    node.appendChild(document.createTextNode(value));
                } else {
                    System.err.println("ERROR Node:" + node);
                    System.err.println("ERROR XPath:" + xpathString);
                }
                return;
            }
            if (target.getNodeType() == 3) {
                target.setNodeValue(value);
            } else if (target.getNodeType() == 2) {
                ((Attr)target).setValue(value);
            } else {
                System.err.println("ERROR Type:unknown" + target.getNodeType());
                System.err.println("ERROR Node:" + node);
                System.err.println("ERROR XPath:" + xpathString);
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static void setAttributeValue(Document document, Element node, String xpathString, String uri, String prefix, String name, String value) {
        block7: {
            try {
                Node target = XPathAPI.selectSingleNode((Node)node, (String)xpathString, (Node)document);
                if (target == null) {
                    System.err.println("ERROR Node:" + node);
                    System.err.println("ERROR XPath:" + xpathString);
                    return;
                }
                if (target.getNodeType() == 1) {
                    Element elem = (Element)target;
                    if (elem.hasAttributeNS(uri, name)) {
                        Attr attr = elem.getAttributeNodeNS(uri, name);
                        attr.setNodeValue(value);
                        attr.setPrefix(prefix);
                    } else {
                        Attr attr = document.createAttributeNS(uri, name);
                        attr.setNodeValue(value);
                        attr.setPrefix(prefix);
                        elem.setAttributeNodeNS(attr);
                    }
                    break block7;
                }
                System.err.println("ERROR Type:unknown" + target.getNodeType());
                System.err.println("ERROR Node:" + node);
                System.err.println("ERROR XPath:" + xpathString);
                return;
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }
}

