/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfLine;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfCell
extends Rectangle {
    private ArrayList lines;
    private PdfLine line;
    private ArrayList images;
    private float leading;
    private int rownumber;
    private int rowspan;
    private float cellspacing;
    private float cellpadding;
    private boolean header = false;
    private int groupNumber;

    public PdfCell(Cell cell, int rownumber, float left, float right, float top, float cellspacing, float cellpadding) {
        super(left, top, right, top);
        this.setBorder(cell.border());
        this.setBorderWidth(cell.borderWidth());
        this.setBorderColor(cell.borderColor());
        this.setBackgroundColor(cell.backgroundColor());
        this.setGrayFill(cell.grayFill());
        this.lines = new ArrayList();
        this.images = new ArrayList();
        this.leading = cell.leading();
        int alignment = cell.horizontalAlignment();
        left += cellspacing + cellpadding;
        right -= cellspacing + cellpadding;
        float height = this.leading + cellpadding;
        float rowSpan = cell.rowspan();
        switch (cell.verticalAlignment()) {
            case 6: {
                height *= rowSpan;
                break;
            }
            case 5: {
                height = (float)((double)height * ((double)rowSpan / 1.5));
                break;
            }
            default: {
                height -= cellpadding * 0.4f;
            }
        }
        this.line = new PdfLine(left, right, alignment, height);
        Iterator i = cell.getElements();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            switch (element.type()) {
                case 32: 
                case 34: 
                case 35: {
                    height = this.addImage((Image)element, left, right, height, alignment);
                    break;
                }
                case 14: {
                    PdfChunk overflow;
                    PdfChunk chunk;
                    if (this.line.size() > 0) {
                        this.line.resetAlignment();
                        this.lines.add(this.line);
                    }
                    ArrayList allActions = new ArrayList();
                    this.processActions(element, null, allActions);
                    int aCounter = 0;
                    Iterator items = ((AbstractList)((List)element).getItems()).iterator();
                    while (items.hasNext()) {
                        ListItem item = (ListItem)items.next();
                        this.line = new PdfLine(left + item.indentationLeft(), right, alignment, this.leading);
                        this.line.setListItem(item);
                        Iterator j = ((AbstractList)item.getChunks()).iterator();
                        while (j.hasNext()) {
                            chunk = new PdfChunk((Chunk)j.next(), (PdfAction)allActions.get(aCounter++));
                            while ((overflow = this.line.add(chunk)) != null) {
                                this.lines.add(this.line);
                                this.line = new PdfLine(left + item.indentationLeft(), right, alignment, this.leading);
                                chunk = overflow;
                            }
                            this.line.resetAlignment();
                            this.lines.add(this.line);
                            this.line = new PdfLine(left + item.indentationLeft(), right, alignment, this.leading);
                        }
                    }
                    this.line = new PdfLine(left, right, alignment, this.leading);
                    break;
                }
                default: {
                    PdfChunk overflow;
                    PdfChunk chunk;
                    ArrayList allActions = new ArrayList();
                    this.processActions(element, null, allActions);
                    int aCounter = 0;
                    Iterator j = ((AbstractList)element.getChunks()).iterator();
                    while (j.hasNext()) {
                        Chunk c = (Chunk)j.next();
                        chunk = new PdfChunk(c, (PdfAction)allActions.get(aCounter++));
                        while ((overflow = this.line.add(chunk)) != null) {
                            this.lines.add(this.line);
                            this.line = new PdfLine(left, right, alignment, this.leading);
                            chunk = overflow;
                        }
                    }
                    switch (element.type()) {
                        case 12: 
                        case 13: 
                        case 16: {
                            this.line.resetAlignment();
                            this.lines.add(this.line);
                            this.line = new PdfLine(left, right, alignment, this.leading);
                        }
                    }
                }
            }
        }
        if (this.line.size() > 0) {
            this.lines.add(this.line);
        }
        if (this.lines.size() > cell.getMaxLines()) {
            String more;
            while (this.lines.size() > cell.getMaxLines()) {
                this.lines.remove(this.lines.size() - 1);
            }
            if (cell.getMaxLines() > 0 && (more = cell.getShowTruncation()) != null && more.length() > 0) {
                PdfLine lastLine = (PdfLine)this.lines.get(this.lines.size() - 1);
                if (lastLine.size() >= 0) {
                    PdfChunk lastChunk = lastLine.getChunk(lastLine.size() - 1);
                    float moreWidth = new PdfChunk(more, lastChunk).width();
                    while (lastChunk.toString().length() > 0 && lastChunk.width() + moreWidth > right - left) {
                        lastChunk.setValue(lastChunk.toString().substring(0, lastChunk.length() - 1));
                    }
                    lastChunk.setValue(String.valueOf(lastChunk.toString()) + more);
                } else {
                    lastLine.add(new PdfChunk(new Chunk(more), null));
                }
            }
        }
        this.setBottom(top - this.leading * (float)(this.lines.size() - 1) - cellpadding - height - 2.0f * cellspacing);
        this.cellpadding = cellpadding;
        this.cellspacing = cellspacing;
        this.rowspan = cell.rowspan();
        this.rownumber = rownumber;
    }

    public float left() {
        return super.left(this.cellspacing);
    }

    public float right() {
        return super.right(this.cellspacing);
    }

    public float top() {
        return super.top(this.cellspacing);
    }

    public float bottom() {
        return super.bottom(this.cellspacing);
    }

    private float addImage(Image i, float left, float right, float height, int alignment) {
        Image image = Image.getInstance(i);
        if (image.scaledWidth() > right - left) {
            image.scaleToFit(right - left, Float.MAX_VALUE);
        }
        if (this.line.size() != 0) {
            this.lines.add(this.line);
        }
        this.line = new PdfLine(left, right, alignment, image.scaledHeight() + 0.4f * this.leading);
        this.lines.add(this.line);
        this.line = new PdfLine(left, right, alignment, this.leading);
        if ((image.alignment() & 2) == 2) {
            left = right - image.scaledWidth();
        } else if ((image.alignment() & 1) == 1) {
            left += (right - left - image.scaledWidth()) / 2.0f;
        }
        image.setAbsolutePosition(left, height + (float)(this.lines.size() - 2) * this.leading + image.scaledHeight() + 0.4f * this.leading);
        this.images.add(image);
        return height + image.scaledHeight() + 0.4f * this.leading;
    }

    public ArrayList getLines(float top, float bottom) {
        float currentPosition = Math.min(this.top(), top);
        this.setTop(currentPosition + this.cellspacing);
        ArrayList<PdfLine> result = new ArrayList<PdfLine>();
        if (this.top() < bottom) {
            return result;
        }
        int size = this.lines.size();
        boolean aboveBottom = true;
        int i = 0;
        while (i < size && aboveBottom) {
            this.line = (PdfLine)this.lines.get(i);
            float lineHeight = this.line.height();
            if ((currentPosition -= lineHeight) > bottom + this.cellpadding) {
                result.add(this.line);
            } else {
                aboveBottom = false;
            }
            ++i;
        }
        float difference = 0.0f;
        if (!this.header) {
            if (aboveBottom) {
                this.lines = new ArrayList();
            } else {
                size = result.size();
                int i2 = 0;
                while (i2 < size) {
                    this.line = (PdfLine)this.lines.remove(0);
                    difference += this.line.height();
                    ++i2;
                }
            }
        }
        if (difference > 0.0f) {
            Iterator i3 = ((AbstractList)this.images).iterator();
            while (i3.hasNext()) {
                Image image = (Image)i3.next();
                image.setAbsolutePosition(image.absoluteX(), image.absoluteY() - difference - this.leading);
            }
        }
        return result;
    }

    public ArrayList getImages(float top, float bottom) {
        if (this.top() < bottom) {
            return new ArrayList();
        }
        top = Math.min(this.top(), top);
        ArrayList<Image> result = new ArrayList<Image>();
        Iterator i = ((AbstractList)this.images).iterator();
        while (i.hasNext() && !this.header) {
            Image image = (Image)i.next();
            float height = image.absoluteY();
            if (!(top - height > bottom + this.cellpadding)) continue;
            image.setAbsolutePosition(image.absoluteX(), top - height);
            result.add(image);
            i.remove();
        }
        return result;
    }

    boolean isHeader() {
        return this.header;
    }

    void setHeader() {
        this.header = true;
    }

    boolean mayBeRemoved() {
        return this.header || this.lines.size() == 0 && this.images.size() == 0;
    }

    public int size() {
        return this.lines.size();
    }

    public int remainingLines() {
        if (this.lines.size() == 0) {
            return 0;
        }
        int result = 0;
        int size = this.lines.size();
        int i = 0;
        while (i < size) {
            PdfLine line = (PdfLine)this.lines.get(i);
            if (line.size() > 0) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public float remainingHeight() {
        float result = 0.0f;
        Iterator i = ((AbstractList)this.images).iterator();
        while (i.hasNext()) {
            Image image = (Image)i.next();
            result += image.scaledHeight();
        }
        return (float)this.remainingLines() * this.leading + 2.0f * this.cellpadding + this.cellspacing + result + this.leading / 2.5f;
    }

    public float leading() {
        return this.leading;
    }

    public int rownumber() {
        return this.rownumber;
    }

    public int rowspan() {
        return this.rowspan;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    protected void processActions(Element element, PdfAction action, ArrayList allActions) {
        String url;
        if (element.type() == 17 && (url = ((Anchor)element).reference()) != null) {
            action = new PdfAction(url);
        }
        switch (element.type()) {
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                Iterator i = ((AbstractList)((ArrayList)((Object)element))).iterator();
                while (i.hasNext()) {
                    this.processActions((Element)i.next(), action, allActions);
                }
                break;
            }
            case 10: {
                allActions.add(action);
                break;
            }
            case 14: {
                Iterator i = ((AbstractList)((List)element).getItems()).iterator();
                while (i.hasNext()) {
                    this.processActions((Element)i.next(), action, allActions);
                }
                break;
            }
            default: {
                ArrayList tmp = element.getChunks();
                int n = element.getChunks().size();
                while (n-- > 0) {
                    allActions.add(action);
                }
                break block0;
            }
        }
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    void setGroupNumber(int number) {
        this.groupNumber = number;
    }

    public Rectangle rectangle(float top, float bottom) {
        Rectangle tmp = new Rectangle(this.left(), this.bottom(), this.right(), this.top());
        tmp.setBorder(this.border);
        tmp.setBorderWidth(this.borderWidth);
        tmp.setBorderColor(this.color);
        tmp.setBackgroundColor(this.background);
        tmp.setGrayFill(this.grayFill);
        if (this.top() > top) {
            tmp.setTop(top);
            tmp.setBorder(this.border - (this.border & 1));
        }
        if (this.bottom() < bottom) {
            tmp.setBottom(bottom);
            tmp.setBorder(this.border - (this.border & 2));
        }
        return tmp;
    }
}

