/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class PdfCopyMerge
extends PdfWriter {
    ArrayList readers = new ArrayList();
    HashMap readers2intrefs = new HashMap();
    HashMap pages2intrefs = new HashMap();
    HashMap visited = new HashMap();
    ArrayList fields = new ArrayList();
    RandomAccessFileOrArray file;
    HashMap fieldTree = new HashMap();
    ArrayList pageRefs = new ArrayList();
    ArrayList pageDics = new ArrayList();
    PdfDictionary resources = new PdfDictionary();
    PdfDictionary form;
    boolean closing = false;
    protected static final HashMap widgetKeys = new HashMap();
    protected static final HashMap fieldKeys = new HashMap();

    static {
        Integer one = new Integer(1);
        widgetKeys.put(PdfName.SUBTYPE, one);
        widgetKeys.put(PdfName.CONTENTS, one);
        widgetKeys.put(PdfName.RECT, one);
        widgetKeys.put(PdfName.NM, one);
        widgetKeys.put(PdfName.M, one);
        widgetKeys.put(PdfName.F, one);
        widgetKeys.put(PdfName.BS, one);
        widgetKeys.put(PdfName.BORDER, one);
        widgetKeys.put(PdfName.AP, one);
        widgetKeys.put(PdfName.AS, one);
        widgetKeys.put(PdfName.C, one);
        widgetKeys.put(PdfName.A, one);
        widgetKeys.put(PdfName.STRUCTPARENT, one);
        widgetKeys.put(PdfName.OC, one);
        widgetKeys.put(PdfName.H, one);
        widgetKeys.put(PdfName.MK, one);
        widgetKeys.put(PdfName.DA, one);
        widgetKeys.put(PdfName.Q, one);
        fieldKeys.put(PdfName.AA, one);
        fieldKeys.put(PdfName.FT, one);
        fieldKeys.put(PdfName.TU, one);
        fieldKeys.put(PdfName.TM, one);
        fieldKeys.put(PdfName.FF, one);
        fieldKeys.put(PdfName.V, one);
        fieldKeys.put(PdfName.DV, one);
        fieldKeys.put(PdfName.DS, one);
        fieldKeys.put(PdfName.RV, one);
        fieldKeys.put(PdfName.OPT, one);
        fieldKeys.put(PdfName.MAXLEN, one);
        fieldKeys.put(PdfName.TI, one);
        fieldKeys.put(PdfName.I, one);
        fieldKeys.put(PdfName.LOCK, one);
        fieldKeys.put(PdfName.SV, one);
    }

    public PdfCopyMerge(OutputStream os) throws DocumentException, IOException {
        this(os, '\u0000');
    }

    public PdfCopyMerge(OutputStream os, char pdfVersion) throws DocumentException, IOException {
        super(new PdfDocument(), os);
        this.pdf.addWriter(this);
        if (pdfVersion != '\u0000') {
            super.setPdfVersion(pdfVersion);
        }
        Document nd = new Document();
        nd.addDocListener(this.pdf);
        nd.open();
    }

    public void addDocument(PdfReader reader) throws DocumentException {
        if (this.readers2intrefs.containsKey(reader)) {
            reader = new PdfReader(reader);
        } else {
            if (reader.isTampered()) {
                throw new DocumentException("The document was reused.");
            }
            reader.consolidateNamedDestinations();
            reader.setTampered(true);
        }
        this.readers2intrefs.put(reader, new IntHashtable());
        this.readers.add(reader);
        int len = reader.getNumberOfPages();
        IntHashtable refs = new IntHashtable();
        int p = 1;
        while (p <= len) {
            refs.put(reader.getPageOrigRef(p).getNumber(), 1);
            ++p;
        }
        this.pages2intrefs.put(reader, refs);
        this.visited.put(reader, new IntHashtable());
        this.fields.add(reader.getAcroFields());
    }

    void propagate(PdfObject obj, PdfIndirectReference refo, boolean restricted) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof PdfIndirectReference) {
            return;
        }
        switch (obj.type()) {
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                Iterator it = dic.getKeys().iterator();
                while (it.hasNext()) {
                    PdfName key = (PdfName)it.next();
                    if (restricted && (key.equals(PdfName.PARENT) || key.equals(PdfName.KIDS))) continue;
                    PdfObject ob = dic.get(key);
                    if (ob != null && ob.isIndirect()) {
                        PRIndirectReference ind = (PRIndirectReference)ob;
                        if (this.setVisited(ind) || this.isPage(ind)) continue;
                        PdfIndirectReference ref = this.getNewReference(ind);
                        this.propagate(PdfReader.getPdfObject(ind), ref, restricted);
                        continue;
                    }
                    this.propagate(ob, null, restricted);
                }
                break;
            }
            case 5: {
                ArrayList list = ((PdfArray)obj).getArrayList();
                PdfArray arr = new PdfArray();
                Iterator it = ((AbstractList)list).iterator();
                while (it.hasNext()) {
                    PdfObject ob = (PdfObject)it.next();
                    if (ob != null && ob.isIndirect()) {
                        PRIndirectReference ind = (PRIndirectReference)ob;
                        if (this.isVisited(ind) || this.isPage(ind)) continue;
                        PdfIndirectReference ref = this.getNewReference(ind);
                        this.propagate(PdfReader.getPdfObject(ind), ref, restricted);
                        continue;
                    }
                    this.propagate(ob, null, restricted);
                }
                break;
            }
            case 10: {
                throw new RuntimeException("Reference pointing to reference.");
            }
        }
    }

    protected PdfArray branchForm(HashMap level, PdfIndirectReference parent) throws IOException {
        PdfArray arr = new PdfArray();
        Iterator it = level.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object obj = level.get(name);
            PdfIndirectReference ind = this.getPdfIndirectReference();
            PdfDictionary dic = new PdfDictionary();
            if (parent != null) {
                dic.put(PdfName.PARENT, parent);
            }
            dic.put(PdfName.T, new PdfString(name, "UnicodeBig"));
            if (obj instanceof HashMap) {
                dic.put(PdfName.KIDS, this.branchForm((HashMap)obj, ind));
                arr.add(ind);
                this.addToBody((PdfObject)dic, ind);
                continue;
            }
            ArrayList list = (ArrayList)obj;
            dic.mergeDifferent((PdfDictionary)list.get(0));
            if (list.size() == 3) {
                dic.mergeDifferent((PdfDictionary)list.get(2));
                int page = (Integer)list.get(1);
                PdfDictionary pageDic = (PdfDictionary)this.pageDics.get(page - 1);
                PdfArray annots = (PdfArray)PdfReader.getPdfObject(pageDic.get(PdfName.ANNOTS));
                if (annots == null) {
                    annots = new PdfArray();
                    pageDic.put(PdfName.ANNOTS, annots);
                }
                annots.add(ind);
            } else {
                PdfArray kids = new PdfArray();
                int k = 1;
                while (k < list.size()) {
                    int page = (Integer)list.get(k);
                    PdfDictionary pageDic = (PdfDictionary)this.pageDics.get(page - 1);
                    PdfArray annots = (PdfArray)PdfReader.getPdfObject(pageDic.get(PdfName.ANNOTS));
                    if (annots == null) {
                        annots = new PdfArray();
                        pageDic.put(PdfName.ANNOTS, annots);
                    }
                    PdfDictionary widget = new PdfDictionary();
                    widget.merge((PdfDictionary)list.get(k + 1));
                    widget.put(PdfName.PARENT, ind);
                    PdfIndirectReference wref = this.addToBody(widget).getIndirectReference();
                    annots.add(wref);
                    kids.add(wref);
                    this.propagate(widget, null, false);
                    k += 2;
                }
                dic.put(PdfName.KIDS, kids);
            }
            arr.add(ind);
            this.addToBody((PdfObject)dic, ind);
            this.propagate(dic, null, false);
        }
        return arr;
    }

    protected void createAcroForms() throws IOException {
        if (this.fieldTree.size() == 0) {
            return;
        }
        this.form = new PdfDictionary();
        this.form.put(PdfName.DR, this.resources);
        this.form.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        this.form.put(PdfName.FIELDS, this.branchForm(this.fieldTree, null));
    }

    public void close() {
        if (this.closing) {
            super.close();
            return;
        }
        this.closing = true;
        try {
            this.closeIt();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeIt() throws DocumentException, IOException {
        int page;
        PdfReader reader;
        int k = 0;
        while (true) {
            if (k >= this.readers.size()) break;
            ((PdfReader)this.readers.get(k)).removeFields();
            ++k;
        }
        int r = 0;
        block7: while (true) {
            if (r >= this.readers.size()) break;
            reader = (PdfReader)this.readers.get(r);
            page = 1;
            while (true) {
                if (page > reader.getNumberOfPages()) {
                    ++r;
                    continue block7;
                }
                this.pageRefs.add(this.getNewReference(reader.getPageOrigRef(page)));
                this.pageDics.add(reader.getPageN(page));
                ++page;
            }
            break;
        }
        this.mergeFields();
        this.createAcroForms();
        r = 0;
        block9: while (true) {
            if (r >= this.readers.size()) break;
            reader = (PdfReader)this.readers.get(r);
            page = 1;
            while (true) {
                if (page > reader.getNumberOfPages()) {
                    ++r;
                    continue block9;
                }
                PdfDictionary dic = reader.getPageN(page);
                PdfIndirectReference pageRef = this.getNewReference(reader.getPageOrigRef(page));
                PdfIndirectReference parent = this.root.addPageRef(pageRef);
                dic.put(PdfName.PARENT, parent);
                this.propagate(dic, pageRef, false);
                ++page;
            }
            break;
        }
        Iterator it = this.readers2intrefs.keySet().iterator();
        while (true) {
            Exception e2;
            Object var7_11;
            if (!it.hasNext()) {
                this.pdf.close();
                return;
            }
            try {
                reader = (PdfReader)it.next();
                this.file = reader.getSafeFile();
                this.file.reOpen();
                IntHashtable t = (IntHashtable)this.readers2intrefs.get(reader);
                int[] keys = t.toOrderedKeys();
                int k2 = 0;
                while (true) {
                    block16: {
                        if (k2 < keys.length) break block16;
                        this.file.close();
                        break;
                    }
                    PRIndirectReference ref = new PRIndirectReference(reader, keys[k2]);
                    this.addToBody(PdfReader.getPdfObject(ref), t.get(keys[k2]));
                    ++k2;
                }
            }
            catch (Throwable throwable) {
                var7_11 = null;
                try {
                    this.file.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                var7_11 = null;
            }
            try {}
            catch (Exception e2) {
                // empty catch block
                continue;
            }
            this.file.close();
            continue;
            break;
        }
    }

    void addPageOffsetToField(HashMap fd, int pageOffset) {
        if (pageOffset == 0) {
            return;
        }
        Iterator it = fd.values().iterator();
        while (it.hasNext()) {
            ArrayList page = ((AcroFields.Item)it.next()).page;
            int k = 0;
            while (k < page.size()) {
                page.set(k, new Integer((Integer)page.get(k) + pageOffset));
                ++k;
            }
        }
    }

    void createWidgets(ArrayList list, AcroFields.Item item) {
        int k = 0;
        while (k < item.merged.size()) {
            list.add(item.page.get(k));
            PdfDictionary merged = (PdfDictionary)item.merged.get(k);
            PdfObject dr = merged.get(PdfName.DR);
            if (dr != null) {
                PdfFormField.mergeResources(this.resources, (PdfDictionary)dr);
            }
            PdfDictionary widget = new PdfDictionary();
            Iterator it = merged.getKeys().iterator();
            while (it.hasNext()) {
                PdfName key = (PdfName)it.next();
                if (!widgetKeys.containsKey(key)) continue;
                widget.put(key, merged.get(key));
            }
            list.add(widget);
            ++k;
        }
    }

    void mergeField(String name, AcroFields.Item item) {
        Object obj;
        String s;
        HashMap map;
        block15: {
            map = this.fieldTree;
            StringTokenizer tk = new StringTokenizer(name, ".");
            if (!tk.hasMoreTokens()) {
                return;
            }
            while (true) {
                s = tk.nextToken();
                obj = map.get(s);
                if (!tk.hasMoreTokens()) break block15;
                if (obj == null) {
                    obj = new HashMap();
                    map.put(s, obj);
                    map = (HashMap)obj;
                    continue;
                }
                if (!(obj instanceof HashMap)) break;
                map = (HashMap)obj;
            }
            return;
        }
        if (obj instanceof HashMap) {
            return;
        }
        PdfDictionary merged = (PdfDictionary)item.merged.get(0);
        if (obj == null) {
            PdfDictionary field = new PdfDictionary();
            Iterator it = merged.getKeys().iterator();
            while (it.hasNext()) {
                PdfName key = (PdfName)it.next();
                if (!fieldKeys.containsKey(key)) continue;
                field.put(key, merged.get(key));
            }
            ArrayList<PdfDictionary> list = new ArrayList<PdfDictionary>();
            list.add(field);
            this.createWidgets(list, item);
            map.put(s, list);
        } else {
            ArrayList list = (ArrayList)obj;
            PdfDictionary field = (PdfDictionary)list.get(0);
            PdfName type1 = (PdfName)field.get(PdfName.FT);
            PdfName type2 = (PdfName)merged.get(PdfName.FT);
            if (type1 == null || !type1.equals(type2)) {
                return;
            }
            int flag1 = 0;
            PdfObject f1 = field.get(PdfName.FF);
            if (f1 != null && f1.isNumber()) {
                flag1 = ((PdfNumber)f1).intValue();
            }
            int flag2 = 0;
            PdfObject f2 = merged.get(PdfName.FF);
            if (f2 != null && f2.isNumber()) {
                flag2 = ((PdfNumber)f2).intValue();
            }
            if (type1.equals(PdfName.BTN)) {
                if (((flag1 ^ flag2) & 0x10000) != 0) {
                    return;
                }
                if ((flag1 & 0x10000) == 0 && ((flag1 ^ flag2) & 0x8000) != 0) {
                    return;
                }
            } else if (type1.equals(PdfName.CH) && ((flag1 ^ flag2) & 0x20000) != 0) {
                return;
            }
            this.createWidgets(list, item);
        }
    }

    void mergeWithMaster(HashMap fd) {
        Iterator it = fd.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            this.mergeField(name, (AcroFields.Item)fd.get(name));
        }
    }

    void mergeFields() {
        int pageOffset = 0;
        int k = 0;
        while (k < this.fields.size()) {
            HashMap fd = ((AcroFields)this.fields.get(k)).getFields();
            this.addPageOffsetToField(fd, pageOffset);
            this.mergeWithMaster(fd);
            pageOffset += ((PdfReader)this.readers.get(k)).getNumberOfPages();
            ++k;
        }
    }

    public PdfIndirectReference getPageReference(int page) {
        return (PdfIndirectReference)this.pageRefs.get(page - 1);
    }

    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) {
        try {
            PdfDocument.PdfCatalog cat = ((PdfDocument)this.document).getCatalog(rootObj);
            if (this.form != null) {
                PdfIndirectReference ref = this.addToBody(this.form).getIndirectReference();
                cat.put(PdfName.ACROFORM, ref);
            }
            return cat;
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    protected PdfIndirectReference getNewReference(PRIndirectReference ref) {
        return new PdfIndirectReference(0, this.getNewObjectNumber(ref.getReader(), ref.getNumber(), 0));
    }

    protected int getNewObjectNumber(PdfReader reader, int number, int generation) {
        IntHashtable refs = (IntHashtable)this.readers2intrefs.get(reader);
        int n = refs.get(number);
        if (n == 0) {
            n = this.getIndirectReferenceNumber();
            refs.put(number, n);
        }
        return n;
    }

    protected boolean isVisited(PdfReader reader, int number, int generation) {
        IntHashtable refs = (IntHashtable)this.readers2intrefs.get(reader);
        return refs.containsKey(number);
    }

    protected boolean isVisited(PRIndirectReference ref) {
        IntHashtable refs = (IntHashtable)this.visited.get(ref.getReader());
        return refs.containsKey(ref.getNumber());
    }

    protected boolean setVisited(PRIndirectReference ref) {
        IntHashtable refs = (IntHashtable)this.visited.get(ref.getReader());
        return refs.put(ref.getNumber(), 1) != 0;
    }

    protected boolean isPage(PRIndirectReference ref) {
        IntHashtable refs = (IntHashtable)this.pages2intrefs.get(ref.getReader());
        return refs.containsKey(ref.getNumber());
    }

    RandomAccessFileOrArray getReaderFile(PdfReader reader) {
        return this.file;
    }
}

