/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.tagext;

import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;

public abstract class TagLibraryInfo {
    protected String prefix;
    protected String uri;
    protected TagInfo[] tags;
    protected TagFileInfo[] tagFiles;
    protected FunctionInfo[] functions;
    protected String tlibversion;
    protected String jspversion;
    protected String shortname;
    protected String urn;
    protected String info;

    protected TagLibraryInfo(String prefix, String uri) {
        this.prefix = prefix;
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public String getPrefixString() {
        return this.prefix;
    }

    public String getShortName() {
        return this.shortname;
    }

    public String getReliableURN() {
        return this.urn;
    }

    public String getInfoString() {
        return this.info;
    }

    public String getRequiredVersion() {
        return this.jspversion;
    }

    public TagInfo[] getTags() {
        return this.tags;
    }

    public TagFileInfo[] getTagFiles() {
        return this.tagFiles;
    }

    public TagInfo getTag(String shortname) {
        TagInfo[] tags = this.getTags();
        if (tags == null || tags.length == 0) {
            return null;
        }
        int i = 0;
        while (i < tags.length) {
            if (tags[i].getTagName().equals(shortname)) {
                return tags[i];
            }
            ++i;
        }
        return null;
    }

    public TagFileInfo getTagFile(String shortname) {
        TagFileInfo[] tagFiles = this.getTagFiles();
        if (tagFiles == null || tagFiles.length == 0) {
            return null;
        }
        int i = 0;
        while (i < tagFiles.length) {
            if (tagFiles[i].getName().equals(shortname)) {
                return tagFiles[i];
            }
            ++i;
        }
        return null;
    }

    public FunctionInfo[] getFunctions() {
        return this.functions;
    }

    public FunctionInfo getFunction(String name) {
        if (this.functions == null || this.functions.length == 0) {
            System.err.println("No functions");
            return null;
        }
        int i = 0;
        while (i < this.functions.length) {
            if (this.functions[i].getName().equals(name)) {
                return this.functions[i];
            }
            ++i;
        }
        return null;
    }
}

